/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameTokenBuilder
implements AssertionBuilder<Element> {
    private static final QName[] KNOWN_ELEMENTS = new QName[]{SP11Constants.USERNAME_TOKEN, SP12Constants.USERNAME_TOKEN};
    PolicyBuilder builder;

    public UsernameTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    @Override
    public Assertion build(Element element, AssertionBuilderFactory factory) {
        NodeList children;
        Element polEl;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        UsernameToken usernameToken = new UsernameToken(consts);
        usernameToken.setOptional(PolicyConstants.isOptional(element));
        usernameToken.setIgnorable(PolicyConstants.isIgnorable(element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (attribute != null) {
            usernameToken.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((polEl = PolicyConstants.findPolicyElement(element)) != null && (children = polEl.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                QName qname2 = new QName((child = (Element)child).getNamespaceURI(), child.getLocalName());
                if ("WssUsernameToken10".equals(qname2.getLocalPart())) {
                    usernameToken.setUseUTProfile10(true);
                    continue;
                }
                if ("WssUsernameToken11".equals(qname2.getLocalPart())) {
                    usernameToken.setUseUTProfile11(true);
                    continue;
                }
                if (SP12Constants.NO_PASSWORD.equals(qname2)) {
                    usernameToken.setNoPassword(true);
                    continue;
                }
                if (SP12Constants.HASH_PASSWORD.equals(qname2)) {
                    usernameToken.setHashPassword(true);
                    continue;
                }
                if (SP12Constants.REQUIRE_DERIVED_KEYS.equals(qname2)) {
                    usernameToken.setDerivedKeys(true);
                    continue;
                }
                if (SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS.equals(qname2)) {
                    usernameToken.setExplicitDerivedKeys(true);
                    continue;
                }
                if (!SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS.equals(qname2)) continue;
                usernameToken.setImpliedDerivedKeys(true);
            }
        }
        return usernameToken;
    }

    @Override
    public QName[] getKnownElements() {
        return KNOWN_ELEMENTS;
    }
}

