/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;

public abstract class TokenWrapper
extends AbstractSecurityAssertion
implements PolicyAssertion,
PolicyContainingAssertion {
    protected PolicyBuilder builder;
    protected Token token;

    public TokenWrapper(SPConstants version, PolicyBuilder b) {
        super(version);
        this.builder = b;
    }

    public void setToken(Token tok) {
        this.token = tok;
    }

    public Token getToken() {
        return this.token;
    }

    public PolicyComponent normalize() {
        if (this.token != null) {
            All all = new All();
            all.addPolicyComponent(this.token.normalize());
            all.addPolicyComponent(this);
            return all;
        }
        return this;
    }

    public Policy getPolicy() {
        if (this.token != null) {
            Policy p = new Policy();
            ExactlyOne ea = new ExactlyOne();
            p.addPolicyComponent(ea);
            All all = new All();
            all.addPolicyComponent(this.token);
            ea.addPolicyComponent(all);
            Policy pc = p.normalize(this.builder.getPolicyRegistry(), true);
            if (pc instanceof Policy) {
                return pc;
            }
            p = new Policy();
            p.addPolicyComponent(pc);
            return p;
        }
        return null;
    }
}

