/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSSamlAssertionValidator;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class STSTokenValidator
implements Validator {
    private STSSamlAssertionValidator samlValidator = new STSSamlAssertionValidator();
    private boolean alwaysValidateToSts;

    public STSTokenValidator() {
    }

    public STSTokenValidator(boolean alwaysValidateToSts) {
        this.alwaysValidateToSts = alwaysValidateToSts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        SoapMessage m = (SoapMessage)data.getMsgContext();
        SecurityToken token = new SecurityToken();
        try {
            STSClient c;
            if (credential.getAssertion() != null) {
                if (!this.alwaysValidateToSts) {
                    this.samlValidator.validate(credential, data);
                    if (this.samlValidator.isTrustVerificationSucceeded()) {
                        return credential;
                    }
                }
                token.setToken(credential.getAssertion().getElement());
            } else if (credential.getUsernametoken() != null) {
                token.setToken(credential.getUsernametoken().getElement());
            } else if (credential.getBinarySecurityToken() != null) {
                token.setToken(credential.getBinarySecurityToken().getElement());
            }
            STSClient sTSClient = c = STSUtils.getClient(m, "sts");
            synchronized (sTSClient) {
                System.setProperty("noprint", "true");
                List<SecurityToken> tokens = c.validateSecurityToken(token);
                SecurityToken returnedToken = tokens.get(0);
                if (returnedToken != token) {
                    AssertionWrapper assertion = new AssertionWrapper(returnedToken.getToken());
                    credential.setTransformedToken(assertion);
                }
                return credential;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
        }
    }
}

