/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.xmlbeans.XmlBeansDataBinding;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlTokenSource;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataWriterImpl
implements DataWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getLogger(XmlBeansDataBinding.class);
    private Schema schema;
    private Message message;

    @Override
    public void write(Object obj, XMLStreamWriter output) {
        this.write(obj, (MessagePartInfo)null, output);
    }

    @Override
    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        block36: {
            try {
                XmlSchemaAnnotated schemaType;
                Class typeClass;
                Class clazz = typeClass = part != null ? part.getTypeClass() : null;
                if (typeClass == null) {
                    typeClass = obj.getClass();
                }
                XmlSchemaAnnotated xmlSchemaAnnotated = schemaType = part == null ? null : part.getXmlSchema();
                if (!XmlObject.class.isAssignableFrom(typeClass) && part != null) {
                    Class<?>[] cls;
                    typeClass = (Class)part.getProperty(XmlAnySimpleType.class.getName());
                    for (Class<?> c : cls = typeClass.getDeclaredClasses()) {
                        if (!"Factory".equals(c.getSimpleName())) continue;
                        try {
                            SchemaType st = (SchemaType)part.getProperty(SchemaType.class.getName());
                            XmlOptions options = new XmlOptions();
                            if (this.schema != null) {
                                options.setValidateOnSet();
                            }
                            if (!st.isDocumentType()) {
                                options.setLoadReplaceDocumentElement(null);
                            }
                            Method meth = c.getMethod("newValue", Object.class);
                            obj = meth.invoke(null, obj);
                            break;
                        }
                        catch (Exception e) {
                            throw new Fault("UNMARSHAL_ERROR", LOG, (Throwable)e, part.getTypeClass());
                        }
                    }
                }
                if (obj != null || !(schemaType instanceof XmlSchemaElement)) {
                    int i;
                    SchemaType st;
                    XMLStreamReader reader;
                    XmlTokenSource source;
                    XmlOptions options = new XmlOptions();
                    if (this.schema != null) {
                        options.setValidateOnSet();
                    }
                    if (this.message != null && MessageUtils.getContextualBoolean(this.message, XmlBeansDataBinding.XMLBEANS_NAMESPACE_HACK, false)) {
                        Node dom2;
                        XmlTokenSource source2;
                        if (obj instanceof XmlObjectBase) {
                            source2 = (XmlObjectBase)obj;
                            dom2 = ((XmlObjectBase)source2).newDomNode(options);
                        } else {
                            source2 = (XmlTokenSource)obj;
                            dom2 = source2.newDomNode(options);
                        }
                        if (dom2 instanceof Document) {
                            Element e = ((Document)dom2).getDocumentElement();
                            StaxUtils.copy(e, output);
                        } else if (dom2 instanceof DocumentFragment) {
                            DocumentFragment frag = (DocumentFragment)dom2;
                            for (Node node = frag.getFirstChild(); node != null; node = node.getNextSibling()) {
                                if (node instanceof Element) {
                                    StaxUtils.copy((Element)node, output);
                                    continue;
                                }
                                if (node instanceof Comment) {
                                    output.writeComment(((Comment)node).getData());
                                    continue;
                                }
                                if (!(node instanceof Text)) continue;
                                output.writeCharacters(((Text)node).getData());
                            }
                        } else {
                            throw new Fault("Invalid document type returned: " + dom2.toString(), LOG);
                        }
                        return;
                    }
                    if (obj instanceof XmlObjectBase) {
                        source = (XmlObjectBase)obj;
                        reader = ((XmlObjectBase)source).newCursorForce().newXMLStreamReader(options);
                    } else {
                        source = (XmlTokenSource)obj;
                        reader = source.newCursor().newXMLStreamReader(options);
                    }
                    SchemaType schemaType2 = st = part == null ? null : (SchemaType)part.getProperty(SchemaType.class.getName());
                    if (st == null) {
                        try {
                            Field f = typeClass.getField("type");
                            if (Modifier.isStatic(f.getModifiers())) {
                                st = (SchemaType)f.get(null);
                                if (part != null) {
                                    part.setProperty(SchemaType.class.getName(), st);
                                }
                            }
                        }
                        catch (Exception es) {
                            es.printStackTrace();
                        }
                    }
                    if ((i = reader.getEventType()) == 7) {
                        i = reader.next();
                    }
                    if (st != null && !st.isDocumentType() || reader.getEventType() == 4) {
                        QName elementName;
                        QName qName = elementName = part != null ? part.getConcreteName() : st.getName();
                        if (StringUtils.isEmpty(elementName.getNamespaceURI())) {
                            output.writeStartElement(elementName.getLocalPart());
                        } else {
                            String pfx = output.getPrefix(elementName.getNamespaceURI());
                            if (StringUtils.isEmpty(pfx)) {
                                output.writeStartElement("tns", elementName.getLocalPart(), elementName.getNamespaceURI());
                                output.writeNamespace("tns", elementName.getNamespaceURI());
                            } else {
                                output.writeStartElement(pfx, elementName.getLocalPart(), elementName.getNamespaceURI());
                            }
                        }
                        StaxUtils.copy(reader, output, true);
                        output.writeEndElement();
                    } else {
                        StaxUtils.copy(reader, output, true);
                    }
                    break block36;
                }
                if (obj == null && this.needToRender(obj, part)) {
                    output.writeStartElement(part.getConcreteName().getNamespaceURI(), part.getConcreteName().getLocalPart());
                    output.writeEndElement();
                }
            }
            catch (XMLStreamException e) {
                throw new Fault("MARSHAL_ERROR", LOG, (Throwable)e, obj);
            }
        }
    }

    private boolean needToRender(Object obj, MessagePartInfo part) {
        if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)part.getXmlSchema();
            return element.isNillable() && element.getMinOccurs() > 0L;
        }
        return false;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }

    @Override
    public void setProperty(String key, Object value) {
        if (Message.class.getName().equals(key)) {
            this.message = (Message)value;
        }
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

