/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.Comparator;
import org.osgi.framework.ServiceReference;

public class RankingComparator
implements Comparator {
    private final boolean naturalOrder;
    private final String rankProperty;

    public RankingComparator(boolean naturalOrder) {
        this(naturalOrder, "service.ranking");
    }

    public RankingComparator(boolean naturalOrder, String rankProperty) {
        this.naturalOrder = naturalOrder;
        this.rankProperty = rankProperty;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            return 0;
        }
        long rank1 = this.getLong((ServiceReference)obj1, this.rankProperty);
        long rank2 = this.getLong((ServiceReference)obj2, this.rankProperty);
        boolean order = this.naturalOrder;
        if (rank1 == rank2) {
            rank1 = this.getLong((ServiceReference)obj1, "service.id");
            rank2 = this.getLong((ServiceReference)obj2, "service.id");
            order = false;
        }
        if (rank1 == rank2) {
            return 0;
        }
        if (order) {
            return rank1 > rank2 ? 1 : -1;
        }
        return rank1 < rank2 ? 1 : -1;
    }

    private long getLong(ServiceReference sr, String property2) {
        Object rankObj = sr.getProperty(property2);
        if (rankObj instanceof Number) {
            return ((Number)rankObj).longValue();
        }
        return 0L;
    }
}

