/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jute.compiler.JFile;
import org.apache.jute.compiler.JRecord;

class CGenerator {
    private String mName;
    private ArrayList<JFile> mInclFiles;
    private ArrayList<JRecord> mRecList;
    private final File outputDirectory;

    CGenerator(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.mName = new File(name).getName();
        this.mInclFiles = ilist;
        this.mRecList = rlist;
    }

    void genCode() throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("unable to create output directory " + this.outputDirectory);
        }
        FileWriter c = new FileWriter(new File(this.outputDirectory, this.mName + ".c"));
        FileWriter h = new FileWriter(new File(this.outputDirectory, this.mName + ".h"));
        h.write("#ifndef __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        h.write("#define __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        h.write("#include \"recordio.h\"\n");
        for (JFile f : this.mInclFiles) {
            h.write("#include \"" + f.getName() + ".h\"\n");
        }
        h.write("\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
        c.write("#include <stdlib.h>\n");
        c.write("#include \"" + this.mName + ".h\"\n\n");
        for (JRecord jr : this.mRecList) {
            jr.genCCode(h, c);
        }
        h.write("\n#ifdef __cplusplus\n}\n#endif\n\n");
        h.write("#endif //" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        h.close();
        c.close();
    }
}

