/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jute.compiler.JFile;
import org.apache.jute.compiler.JRecord;

class CppGenerator {
    private String mName;
    private ArrayList<JFile> mInclFiles;
    private ArrayList<JRecord> mRecList;
    private final File outputDirectory;

    CppGenerator(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.mName = new File(name).getName();
        this.mInclFiles = ilist;
        this.mRecList = rlist;
    }

    void genCode() throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("unable to create output directory " + this.outputDirectory);
        }
        FileWriter cc = new FileWriter(new File(this.outputDirectory, this.mName + ".cc"));
        FileWriter hh = new FileWriter(new File(this.outputDirectory, this.mName + ".hh"));
        hh.write("#ifndef __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        hh.write("#define __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        hh.write("#include \"recordio.hh\"\n");
        for (JFile f : this.mInclFiles) {
            hh.write("#include \"" + f.getName() + ".hh\"\n");
        }
        cc.write("#include \"" + this.mName + ".hh\"\n");
        for (JRecord jr : this.mRecList) {
            jr.genCppCode(hh, cc);
        }
        hh.write("#endif //" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        hh.close();
        cc.close();
    }
}

