/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DOMURIDereferencer
implements URIDereferencer {
    private WSDocInfo wsDocInfo;

    public void setWsDocInfo(WSDocInfo docInfo) {
        this.wsDocInfo = docInfo;
    }

    public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
        if (uriRef == null) {
            throw new NullPointerException("uriRef cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        DOMURIReference domRef = (DOMURIReference)uriRef;
        Attr uriAttr = (Attr)domRef.getHere();
        String uri = uriRef.getURI();
        DOMCryptoContext dcc = (DOMCryptoContext)context;
        if (uri != null && uri.length() != 0 && uri.charAt(0) == '#') {
            Element referencedElem;
            String id = uri.substring(1);
            if (id.startsWith("xpointer(id(")) {
                int i1 = id.indexOf(39);
                int i2 = id.indexOf(39, i1 + 1);
                id = id.substring(i1 + 1, i2);
            }
            if ((referencedElem = dcc.getElementById(id)) != null) {
                IdResolver.registerElementById(referencedElem, id);
            }
        }
        try {
            String baseURI = context.getBaseURI();
            XMLSignatureInput in = null;
            EnvelopeIdResolver envelopeResolver = new EnvelopeIdResolver();
            if (envelopeResolver.engineCanResolve(uriAttr, baseURI)) {
                envelopeResolver.setWsDocInfo(this.wsDocInfo);
                in = envelopeResolver.engineResolve(uriAttr, baseURI);
            } else {
                ResourceResolver resolver2 = ResourceResolver.getInstance(uriAttr, baseURI);
                in = resolver2.resolve(uriAttr, baseURI);
            }
            return new DOMSubTreeData(in.getSubNode(), in.isExcludeComments());
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
    }
}

