/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog(SAMLTokenProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug("Found SAML Assertion element");
        }
        Validator validator = data.getValidator(new QName(elem.getNamespaceURI(), elem.getLocalName()));
        Credential credential = this.handleSAMLToken(elem, data, validator, wsDocInfo);
        AssertionWrapper assertion = credential.getAssertion();
        if (log.isDebugEnabled()) {
            log.debug("SAML Assertion issuer " + assertion.getIssuerString());
            log.debug(DOM2Writer.nodeToString(elem));
        }
        wsDocInfo.addTokenElement(elem);
        WSSecurityEngineResult result = null;
        result = assertion.isSigned() ? new WSSecurityEngineResult(16, assertion) : new WSSecurityEngineResult(8, assertion);
        String id = assertion.getId();
        result.put("id", id);
        if (credential.getTransformedToken() != null) {
            result.put("transformed-token", credential.getTransformedToken());
        }
        if (validator != null) {
            result.put("validated-token", Boolean.TRUE);
        }
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    public Credential handleSAMLToken(Element token, RequestData data, Validator validator, WSDocInfo docInfo) throws WSSecurityException {
        AssertionWrapper assertion = new AssertionWrapper(token);
        if (assertion.isSigned()) {
            assertion.verifySignature(data, docInfo);
        }
        assertion.parseHOKSubject(data, docInfo);
        Credential credential = new Credential();
        credential.setAssertion(assertion);
        if (validator != null) {
            return validator.validate(credential, data);
        }
        return credential;
    }
}

