/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SAMLUtil {
    public static AssertionWrapper getAssertionFromKeyIdentifier(SecurityTokenReference secRef, Element strElement, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        String keyIdentifierValue = secRef.getKeyIdentifierValue();
        String type = secRef.getKeyIdentifierValueType();
        WSSecurityEngineResult result = wsDocInfo.getResult(keyIdentifierValue);
        AssertionWrapper assertion = null;
        Element token = null;
        if (result != null) {
            assertion = (AssertionWrapper)result.get("saml-assertion");
            return assertion;
        }
        token = secRef.findProcessedTokenElement(strElement.getOwnerDocument(), wsDocInfo, request.getCallbackHandler(), keyIdentifierValue, type);
        if (token != null) {
            return new AssertionWrapper(token);
        }
        token = secRef.findUnprocessedTokenElement(strElement.getOwnerDocument(), wsDocInfo, request.getCallbackHandler(), keyIdentifierValue, type);
        Processor proc = request.getWssConfig().getProcessor(WSSecurityEngine.SAML_TOKEN);
        List<WSSecurityEngineResult> samlResult = proc.handleToken(token, request, wsDocInfo);
        return (AssertionWrapper)samlResult.get(0).get("saml-assertion");
    }

    public static SAMLKeyInfo getCredentialFromSubject(AssertionWrapper assertion, RequestData data, WSDocInfo docInfo, boolean bspCompliant) throws WSSecurityException {
        if (assertion.getSaml1() != null) {
            return SAMLUtil.getCredentialFromSubject(assertion.getSaml1(), data, docInfo, bspCompliant);
        }
        return SAMLUtil.getCredentialFromSubject(assertion.getSaml2(), data, docInfo, bspCompliant);
    }

    private static byte[] getSecretKeyFromCallbackHandler(String id, CallbackHandler cb) throws WSSecurityException {
        if (cb != null) {
            WSPasswordCallback pwcb = new WSPasswordCallback(id, 9);
            try {
                cb.handle(new Callback[]{pwcb});
            }
            catch (Exception e1) {
                throw new WSSecurityException(0, "noKey", new Object[]{id}, e1);
            }
            return pwcb.getKey();
        }
        return null;
    }

    public static SAMLKeyInfo getCredentialFromSubject(Assertion assertion, RequestData data, WSDocInfo docInfo, boolean bspCompliant) throws WSSecurityException {
        byte[] key = SAMLUtil.getSecretKeyFromCallbackHandler(assertion.getID(), data.getCallbackHandler());
        if (key != null && key.length > 0) {
            return new SAMLKeyInfo(key);
        }
        for (Statement stmt : assertion.getStatements()) {
            Subject samlSubject = null;
            if (stmt instanceof AttributeStatement) {
                AttributeStatement attrStmt = (AttributeStatement)stmt;
                samlSubject = attrStmt.getSubject();
            } else if (stmt instanceof AuthenticationStatement) {
                AuthenticationStatement authStmt = (AuthenticationStatement)stmt;
                samlSubject = authStmt.getSubject();
            } else {
                AuthorizationDecisionStatement authzStmt = (AuthorizationDecisionStatement)stmt;
                samlSubject = authzStmt.getSubject();
            }
            if (samlSubject == null) {
                throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
            }
            Element sub = samlSubject.getSubjectConfirmation().getDOM();
            Element keyInfoElement = WSSecurityUtil.getDirectChildElement(sub, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            if (keyInfoElement == null) continue;
            return SAMLUtil.getCredentialFromKeyInfo(keyInfoElement, data, docInfo, bspCompliant);
        }
        return null;
    }

    public static SAMLKeyInfo getCredentialFromSubject(org.opensaml.saml2.core.Assertion assertion, RequestData data, WSDocInfo docInfo, boolean bspCompliant) throws WSSecurityException {
        byte[] key = SAMLUtil.getSecretKeyFromCallbackHandler(assertion.getID(), data.getCallbackHandler());
        if (key != null && key.length > 0) {
            return new SAMLKeyInfo(key);
        }
        org.opensaml.saml2.core.Subject samlSubject = assertion.getSubject();
        if (samlSubject == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
        }
        List<SubjectConfirmation> subjectConfList = samlSubject.getSubjectConfirmations();
        for (SubjectConfirmation subjectConfirmation : subjectConfList) {
            SubjectConfirmationData subjConfData = subjectConfirmation.getSubjectConfirmationData();
            Element sub = subjConfData.getDOM();
            Element keyInfoElement = WSSecurityUtil.getDirectChildElement(sub, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            if (keyInfoElement == null) continue;
            return SAMLUtil.getCredentialFromKeyInfo(keyInfoElement, data, docInfo, bspCompliant);
        }
        return null;
    }

    public static SAMLKeyInfo getCredentialFromKeyInfo(Element keyInfoElement, RequestData data, WSDocInfo docInfo, boolean bspCompliant) throws WSSecurityException {
        for (Node node = keyInfoElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            QName el = new QName(node.getNamespaceURI(), node.getLocalName());
            if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                EncryptedKeyProcessor proc = new EncryptedKeyProcessor();
                List<WSSecurityEngineResult> result = proc.handleToken((Element)node, data, docInfo);
                byte[] secret = (byte[])result.get(0).get("secret");
                return new SAMLKeyInfo(secret);
            }
            if (!el.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret"))) continue;
            Text txt = (Text)node.getFirstChild();
            return new SAMLKeyInfo(Base64.decode(txt.getData()));
        }
        X509Certificate[] certs = null;
        KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM");
        DOMStructure keyInfoStructure = new DOMStructure(keyInfoElement);
        try {
            KeyInfo keyInfo = keyInfoFactory.unmarshalKeyInfo(keyInfoStructure);
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    PublicKey publicKey = ((KeyValue)xmlStructure).getPublicKey();
                    return new SAMLKeyInfo(publicKey);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                List<?> x509Data = ((X509Data)xmlStructure).getContent();
                for (int j = 0; j < x509Data.size(); ++j) {
                    Object x509obj = x509Data.get(j);
                    if (x509obj instanceof X509Certificate) {
                        certs = new X509Certificate[]{(X509Certificate)x509obj};
                        return new SAMLKeyInfo(certs);
                    }
                    if (!(x509obj instanceof X509IssuerSerial)) continue;
                    if (data.getSigCrypto() == null) {
                        throw new WSSecurityException(0, "noSigCryptoFile");
                    }
                    CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
                    cryptoType.setIssuerSerial(((X509IssuerSerial)x509obj).getIssuerName(), ((X509IssuerSerial)x509obj).getSerialNumber());
                    certs = data.getSigCrypto().getX509Certificates(cryptoType);
                    if (certs == null || certs.length < 1) {
                        throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
                    }
                    return new SAMLKeyInfo(certs);
                }
            }
        }
        catch (Exception ex) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"}, ex);
        }
        return null;
    }
}

