/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml.ext.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.saml.ext.bean.ActionBean;
import org.apache.ws.security.saml.ext.bean.AttributeBean;
import org.apache.ws.security.saml.ext.bean.AttributeStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthDecisionStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthenticationStatementBean;
import org.apache.ws.security.saml.ext.bean.ConditionsBean;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.apache.ws.security.util.UUIDGenerator;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.Action;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AttributeValue;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.ConfirmationMethod;
import org.opensaml.saml1.core.DecisionTypeEnumeration;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml1.core.SubjectConfirmation;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.KeyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML1ComponentBuilder {
    private static SAMLObjectBuilder<Assertion> assertionV1Builder;
    private static SAMLObjectBuilder<Conditions> conditionsV1Builder;
    private static SAMLObjectBuilder<AuthenticationStatement> authenticationStatementV1Builder;
    private static SAMLObjectBuilder<Subject> subjectV1Builder;
    private static SAMLObjectBuilder<NameIdentifier> nameIdentifierV1Builder;
    private static SAMLObjectBuilder<SubjectConfirmation> subjectConfirmationV1Builder;
    private static SAMLObjectBuilder<ConfirmationMethod> confirmationMethodV1Builder;
    private static SAMLObjectBuilder<AttributeStatement> attributeStatementV1Builder;
    private static SAMLObjectBuilder<Attribute> attributeV1Builder;
    private static XSStringBuilder stringBuilder;
    private static SAMLObjectBuilder<AuthorizationDecisionStatement> authorizationDecisionStatementV1Builder;
    private static SAMLObjectBuilder<Action> actionElementV1Builder;
    private static XMLObjectBuilderFactory builderFactory;

    public static Assertion createSamlv1Assertion(String issuer) {
        if (assertionV1Builder == null && (assertionV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME)) == null) {
            throw new IllegalStateException("OpenSaml engine not initialized. Please make sure to initialize the OpenSaml engine prior using it");
        }
        Assertion assertion = (Assertion)assertionV1Builder.buildObject(Assertion.DEFAULT_ELEMENT_NAME, Assertion.TYPE_NAME);
        assertion.setVersion(SAMLVersion.VERSION_11);
        assertion.setIssuer(issuer);
        assertion.setIssueInstant(new DateTime());
        assertion.setID(UUIDGenerator.getUUID());
        return assertion;
    }

    public static Subject createSaml1v1Subject(SubjectBean subjectBean) throws SecurityException, WSSecurityException {
        if (subjectV1Builder == null) {
            subjectV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        }
        if (nameIdentifierV1Builder == null) {
            nameIdentifierV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(NameIdentifier.DEFAULT_ELEMENT_NAME);
        }
        if (subjectConfirmationV1Builder == null) {
            subjectConfirmationV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        }
        if (confirmationMethodV1Builder == null) {
            confirmationMethodV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(ConfirmationMethod.DEFAULT_ELEMENT_NAME);
        }
        Subject subject = subjectV1Builder.buildObject();
        NameIdentifier nameIdentifier = nameIdentifierV1Builder.buildObject();
        SubjectConfirmation subjectConfirmation = subjectConfirmationV1Builder.buildObject();
        ConfirmationMethod confirmationMethod = confirmationMethodV1Builder.buildObject();
        nameIdentifier.setNameQualifier(subjectBean.getSubjectNameQualifier());
        nameIdentifier.setNameIdentifier(subjectBean.getSubjectName());
        nameIdentifier.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        String confirmationMethodStr = subjectBean.getSubjectConfirmationMethod();
        if (confirmationMethodStr == null) {
            confirmationMethodStr = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        }
        confirmationMethod.setConfirmationMethod(confirmationMethodStr);
        subjectConfirmation.getConfirmationMethods().add(confirmationMethod);
        if (subjectBean.getKeyInfo() != null) {
            KeyInfo keyInfo = SAML1ComponentBuilder.createKeyInfo(subjectBean.getKeyInfo());
            subjectConfirmation.setKeyInfo(keyInfo);
        }
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(subjectConfirmation);
        return subject;
    }

    public static KeyInfo createKeyInfo(KeyInfoBean keyInfo) throws SecurityException, WSSecurityException {
        if (keyInfo.getElement() != null) {
            return (KeyInfo)OpenSAMLUtil.fromDom(keyInfo.getElement());
        }
        BasicX509Credential keyInfoCredential = new BasicX509Credential();
        if (keyInfo.getCertificate() != null) {
            keyInfoCredential.setEntityCertificate(keyInfo.getCertificate());
        } else if (keyInfo.getPublicKey() != null) {
            keyInfoCredential.setPublicKey(keyInfo.getPublicKey());
        }
        X509KeyInfoGeneratorFactory kiFactory = new X509KeyInfoGeneratorFactory();
        KeyInfoBean.CERT_IDENTIFIER certIdentifier = keyInfo.getCertIdentifer();
        switch (certIdentifier) {
            case X509_CERT: {
                kiFactory.setEmitEntityCertificate(true);
                break;
            }
            case KEY_VALUE: {
                kiFactory.setEmitPublicKeyValue(true);
                break;
            }
            case X509_ISSUER_SERIAL: {
                kiFactory.setEmitX509IssuerSerial(true);
            }
        }
        return kiFactory.newInstance().generate(keyInfoCredential);
    }

    public static Conditions createSamlv1Conditions(ConditionsBean conditionsBean) {
        if (conditionsV1Builder == null) {
            conditionsV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        }
        Conditions conditions = (Conditions)conditionsV1Builder.buildObject(Conditions.TYPE_NAME);
        if (conditionsBean == null) {
            DateTime newNotBefore = new DateTime();
            conditions.setNotBefore(newNotBefore);
            conditions.setNotOnOrAfter(newNotBefore.plusMinutes(5));
            return conditions;
        }
        int tokenPeriodMinutes = conditionsBean.getTokenPeriodMinutes();
        DateTime notBefore = conditionsBean.getNotBefore();
        DateTime notAfter = conditionsBean.getNotAfter();
        if (notBefore != null && notAfter != null) {
            if (notBefore.isAfter(notAfter)) {
                throw new IllegalStateException("The value of notBefore may not be after the value of notAfter");
            }
            conditions.setNotBefore(notBefore);
            conditions.setNotOnOrAfter(notAfter);
        } else {
            DateTime newNotBefore = new DateTime();
            conditions.setNotBefore(newNotBefore);
            conditions.setNotOnOrAfter(newNotBefore.plusMinutes(tokenPeriodMinutes));
        }
        return conditions;
    }

    public static List<AuthenticationStatement> createSamlv1AuthenticationStatement(List<AuthenticationStatementBean> authBeans) throws SecurityException, WSSecurityException {
        ArrayList<AuthenticationStatement> authenticationStatements = new ArrayList<AuthenticationStatement>();
        if (authenticationStatementV1Builder == null) {
            authenticationStatementV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthenticationStatement.DEFAULT_ELEMENT_NAME);
        }
        if (authBeans != null && authBeans.size() > 0) {
            for (AuthenticationStatementBean statementBean : authBeans) {
                AuthenticationStatement authenticationStatement = (AuthenticationStatement)authenticationStatementV1Builder.buildObject(AuthenticationStatement.DEFAULT_ELEMENT_NAME, AuthenticationStatement.TYPE_NAME);
                Subject authSubject = SAML1ComponentBuilder.createSaml1v1Subject(statementBean.getSubject());
                authenticationStatement.setSubject(authSubject);
                if (statementBean.getAuthenticationInstant() != null) {
                    authenticationStatement.setAuthenticationInstant(statementBean.getAuthenticationInstant());
                } else {
                    authenticationStatement.setAuthenticationInstant(new DateTime());
                }
                authenticationStatement.setAuthenticationMethod(SAML1ComponentBuilder.transformAuthenticationMethod(statementBean.getAuthenticationMethod()));
                authenticationStatements.add(authenticationStatement);
            }
        }
        return authenticationStatements;
    }

    private static String transformAuthenticationMethod(String sourceMethod) {
        String transformedMethod = "";
        if ("Password".equals(sourceMethod)) {
            transformedMethod = "urn:oasis:names:tc:SAML:1.0:am:password";
        }
        return transformedMethod;
    }

    public static List<AttributeStatement> createSamlv1AttributeStatement(List<AttributeStatementBean> attributeData) throws SecurityException, WSSecurityException {
        if (attributeStatementV1Builder == null) {
            attributeStatementV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        }
        ArrayList<AttributeStatement> attributeStatements = new ArrayList<AttributeStatement>();
        if (attributeData != null && attributeData.size() > 0) {
            for (AttributeStatementBean statementBean : attributeData) {
                AttributeStatement attributeStatement = attributeStatementV1Builder.buildObject();
                Subject attributeSubject = SAML1ComponentBuilder.createSaml1v1Subject(statementBean.getSubject());
                attributeStatement.setSubject(attributeSubject);
                for (AttributeBean values : statementBean.getSamlAttributes()) {
                    Attribute samlAttribute = SAML1ComponentBuilder.createSamlv1Attribute(values.getSimpleName(), values.getQualifiedName(), values.getAttributeValues());
                    attributeStatement.getAttributes().add(samlAttribute);
                }
                attributeStatements.add(attributeStatement);
            }
        }
        return attributeStatements;
    }

    public static Attribute createSamlv1Attribute(String attributeName, String attributeUrn, List<String> values) {
        if (attributeV1Builder == null) {
            attributeV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        }
        if (stringBuilder == null) {
            stringBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        }
        Attribute attribute = attributeV1Builder.buildObject();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeNamespace(attributeUrn);
        for (String value : values) {
            XSString attribute1 = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            attribute1.setValue(value);
            attribute.getAttributeValues().add(attribute1);
        }
        return attribute;
    }

    public static List<AuthorizationDecisionStatement> createSamlv1AuthorizationDecisionStatement(List<AuthDecisionStatementBean> decisionData) throws SecurityException, WSSecurityException {
        ArrayList<AuthorizationDecisionStatement> authDecisionStatements = new ArrayList<AuthorizationDecisionStatement>();
        if (authorizationDecisionStatementV1Builder == null) {
            authorizationDecisionStatementV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthorizationDecisionStatement.DEFAULT_ELEMENT_NAME);
        }
        if (decisionData != null && decisionData.size() > 0) {
            for (AuthDecisionStatementBean decisionStatementBean : decisionData) {
                AuthorizationDecisionStatement authDecision = authorizationDecisionStatementV1Builder.buildObject();
                Subject authDecisionSubject = SAML1ComponentBuilder.createSaml1v1Subject(decisionStatementBean.getSubject());
                authDecision.setSubject(authDecisionSubject);
                authDecision.setResource(decisionStatementBean.getResource());
                authDecision.setDecision(SAML1ComponentBuilder.transformDecisionType(decisionStatementBean.getDecision()));
                for (ActionBean actionBean : decisionStatementBean.getActions()) {
                    Action actionElement = SAML1ComponentBuilder.createSamlv1Action(actionBean);
                    authDecision.getActions().add(actionElement);
                }
                authDecisionStatements.add(authDecision);
            }
        }
        return authDecisionStatements;
    }

    public static Action createSamlv1Action(ActionBean actionBean) {
        if (actionElementV1Builder == null) {
            actionElementV1Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Action.DEFAULT_ELEMENT_NAME);
        }
        Action actionElement = actionElementV1Builder.buildObject();
        actionElement.setNamespace(actionBean.getActionNamespace());
        actionElement.setContents(actionBean.getContents());
        return actionElement;
    }

    private static DecisionTypeEnumeration transformDecisionType(AuthDecisionStatementBean.Decision decision) {
        DecisionTypeEnumeration decisionTypeEnum = DecisionTypeEnumeration.DENY;
        if (decision.equals((Object)AuthDecisionStatementBean.Decision.PERMIT)) {
            decisionTypeEnum = DecisionTypeEnumeration.PERMIT;
        } else if (decision.equals((Object)AuthDecisionStatementBean.Decision.INDETERMINATE)) {
            decisionTypeEnum = DecisionTypeEnumeration.INDETERMINATE;
        }
        return decisionTypeEnum;
    }

    static {
        builderFactory = Configuration.getBuilderFactory();
    }
}

