/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedKeySTRParser
implements STRParser {
    private static final Log LOG = LogFactory.getLog(EncryptedKeySTRParser.class);
    private X509Certificate[] certs;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        SecurityTokenReference secRef;
        Crypto crypto = data.getDecCrypto();
        WSSConfig config = data.getWssConfig();
        boolean bspCompliant = true;
        if (config != null) {
            bspCompliant = config.isWsiBSPCompliant();
        }
        if ((secRef = new SecurityTokenReference(strElement, bspCompliant)).containsX509Data() || secRef.containsX509IssuerSerial()) {
            this.certs = secRef.getX509IssuerSerial(crypto);
        } else if (secRef.containsKeyIdentifier()) {
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                AssertionWrapper assertion = SAMLUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                if (bspCompliant) {
                    BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                }
                SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
                this.certs = samlKi.getCerts();
            } else {
                if (bspCompliant) {
                    BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, null);
                }
                this.certs = secRef.getKeyIdentifier(crypto);
            }
        } else {
            String uri;
            WSSecurityEngineResult result;
            if (!secRef.containsReference()) throw new WSSecurityException(3, "unsupportedKeyId");
            if (wsDocInfo != null && (result = wsDocInfo.getResult(uri = secRef.getReference().getURI())) != null) {
                int action = (Integer)result.get("action");
                if (4096 == action) {
                    if (bspCompliant) {
                        BinarySecurity token = (BinarySecurity)result.get("binary-security-token");
                        BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, token);
                    }
                    this.certs = (X509Certificate[])result.get("x509-certificates");
                } else {
                    if (8 != action && 16 != action) throw new WSSecurityException(1, "unsupportedBinaryTokenType", null);
                    AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
                    if (bspCompliant) {
                        BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                    }
                    SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
                    this.certs = keyInfo.getCerts();
                }
            }
            if (this.certs == null) {
                Element bstElement = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler());
                QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
                if (!el.equals(WSSecurityEngine.BINARY_TOKEN)) throw new WSSecurityException(1, "unsupportedBinaryTokenType", null);
                X509Security token = new X509Security(bstElement);
                if (bspCompliant) {
                    BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, token);
                }
                this.certs = new X509Certificate[]{token.getX509Certificate(crypto)};
            }
        }
        if (!LOG.isDebugEnabled() || this.certs == null || this.certs[0] == null) return;
        LOG.debug("cert: " + this.certs[0]);
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return null;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }
}

