/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTokenRefSTRParser
implements STRParser {
    public static final String SIGNATURE_METHOD = "signature_method";
    private byte[] secretKey;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        SecurityTokenReference secRef;
        boolean bspCompliant = true;
        WSSConfig config = data.getWssConfig();
        if (config != null) {
            bspCompliant = config.isWsiBSPCompliant();
        }
        if ((secRef = new SecurityTokenReference(strElement, bspCompliant)).containsReference()) {
            WSSecurityEngineResult result;
            Reference reference = secRef.getReference();
            String uri = reference.getURI();
            String id = uri;
            if (id.charAt(0) == '#') {
                id = id.substring(1);
            }
            if ((result = wsDocInfo.getResult(id)) != null) {
                int action = (Integer)result.get("action");
                if (4 == action) {
                    if (bspCompliant) {
                        BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                    }
                    this.secretKey = (byte[])result.get("secret");
                } else if (2048 == action) {
                    DerivedKeyToken dkt = (DerivedKeyToken)result.get("derived-key-token");
                    byte[] secret = (byte[])result.get("secret");
                    String algorithm = (String)parameters.get(SIGNATURE_METHOD);
                    this.secretKey = dkt.deriveKey(WSSecurityUtil.getKeyLength(algorithm), secret);
                } else if (8 == action || 16 == action) {
                    AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
                    if (bspCompliant) {
                        BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                    }
                    SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
                    this.secretKey = keyInfo.getSecret();
                } else if (1024 == action) {
                    this.secretKey = (byte[])result.get("secret");
                }
            } else {
                this.secretKey = this.getSecretKeyFromToken(id, reference.getValueType(), data);
                if (this.secretKey == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{id});
                }
            }
        } else if (secRef.containsKeyIdentifier()) {
            String valueType = secRef.getKeyIdentifierValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) {
                AssertionWrapper assertion = SAMLUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                if (bspCompliant) {
                    BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                }
                SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
                this.secretKey = samlKi.getSecret();
            } else {
                if (bspCompliant && "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType)) {
                    BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                }
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), secRef.getKeyIdentifierValueType(), data);
            }
        } else {
            throw new WSSecurityException(6, "noReference");
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    private byte[] getSecretKeyFromToken(String id, String type, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, 9, data);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            data.getCallbackHandler().handle(callbacks);
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
        }
        return pwcb.getKey();
    }
}

