/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class SignatureTrustValidator
implements Validator {
    private static Log LOG = LogFactory.getLog(SignatureTrustValidator.class);

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        boolean trust;
        if (credential == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        X509Certificate[] certs = credential.getCertificates();
        PublicKey publicKey = credential.getPublicKey();
        Crypto crypto = this.getCrypto(data);
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
        if (certs != null && certs.length > 0) {
            this.validateCertificates(certs);
            trust = false;
            trust = certs.length == 1 ? this.verifyTrustInCert(certs[0], crypto) : this.verifyTrustInCerts(certs, crypto);
            if (trust) {
                return credential;
            }
        }
        if (publicKey != null && (trust = this.validatePublicKey(publicKey, crypto))) {
            return credential;
        }
        throw new WSSecurityException(5);
    }

    protected Crypto getCrypto(RequestData data) {
        return data.getSigCrypto();
    }

    protected void validateCertificates(X509Certificate[] certificates) throws WSSecurityException {
        try {
            for (int i = 0; i < certificates.length; ++i) {
                certificates[i].checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            throw new WSSecurityException(6, "invalidCert", null, e);
        }
        catch (CertificateNotYetValidException e) {
            throw new WSSecurityException(6, "invalidCert", null, e);
        }
    }

    protected boolean verifyTrustInCert(X509Certificate cert, Crypto crypto) throws WSSecurityException {
        String subjectString = cert.getSubjectX500Principal().getName();
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transmitted certificate has subject " + subjectString);
            LOG.debug("Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")");
        }
        if (this.isCertificateInKeyStore(crypto, cert)) {
            return true;
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.SUBJECT_DN);
        cryptoType.setSubjectDN(issuerString);
        X509Certificate[] foundCerts = crypto.getX509Certificates(cryptoType);
        if (foundCerts == null || foundCerts.length < 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No certs found in keystore for issuer " + issuerString + " of certificate for " + subjectString);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing to validate certificate path for issuer " + issuerString);
        }
        X509Certificate[] x509certs = new X509Certificate[foundCerts.length + 1];
        x509certs[0] = cert;
        for (int j = 0; j < foundCerts.length; ++j) {
            x509certs[j + 1] = foundCerts[j];
        }
        if (crypto.verifyTrust(x509certs)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificate path has been verified for certificate with subject " + subjectString);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificate path could not be verified for certificate with subject " + subjectString);
        }
        return false;
    }

    protected boolean isCertificateInKeyStore(Crypto crypto, X509Certificate cert) throws WSSecurityException {
        String issuerString = cert.getIssuerX500Principal().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(issuerString, issuerSerial);
        X509Certificate[] foundCerts = crypto.getX509Certificates(cryptoType);
        if (foundCerts != null && foundCerts[0] != null && foundCerts[0].equals(cert)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Direct trust for certificate with " + cert.getSubjectX500Principal().getName());
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No certificate found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")");
        }
        return false;
    }

    protected boolean verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto) throws WSSecurityException {
        String subjectString = certificates[0].getSubjectX500Principal().getName();
        if (certificates != null && certificates.length > 1 && crypto.verifyTrust(certificates)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Certificate path has been verified for certificate with subject " + subjectString);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificate path could not be verified for certificate with subject " + subjectString);
        }
        return false;
    }

    protected boolean validatePublicKey(PublicKey publicKey, Crypto crypto) throws WSSecurityException {
        return crypto.verifyTrust(publicKey);
    }
}

