/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.proto.WatcherEvent;

public class WatchedEvent {
    private final Watcher.Event.KeeperState keeperState;
    private final Watcher.Event.EventType eventType;
    private String path;

    public WatchedEvent(Watcher.Event.EventType eventType, Watcher.Event.KeeperState keeperState, String path) {
        this.keeperState = keeperState;
        this.eventType = eventType;
        this.path = path;
    }

    public WatchedEvent(WatcherEvent eventMessage) {
        this.keeperState = Watcher.Event.KeeperState.fromInt(eventMessage.getState());
        this.eventType = Watcher.Event.EventType.fromInt(eventMessage.getType());
        this.path = eventMessage.getPath();
    }

    public Watcher.Event.KeeperState getState() {
        return this.keeperState;
    }

    public Watcher.Event.EventType getType() {
        return this.eventType;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        if (this.path == null) {
            return "WatchedEvent: Server state change. New state: " + (Object)((Object)this.keeperState);
        }
        return "WatchedEvent: Znode change. Path: " + this.path + " Type: " + (Object)((Object)this.eventType);
    }

    public WatcherEvent getWrapper() {
        return new WatcherEvent(this.eventType.getIntValue(), this.keeperState.getIntValue(), this.path);
    }
}

