/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Date;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ConnectionMXBean;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;

public class ConnectionBean
implements ConnectionMXBean,
ZKMBeanInfo {
    private static final Logger LOG = Logger.getLogger(ConnectionBean.class);
    private ServerCnxn connection;
    private ZooKeeperServer zk;
    private Date timeCreated;

    public ConnectionBean(ServerCnxn connection, ZooKeeperServer zk) {
        this.connection = connection;
        this.zk = zk;
        this.timeCreated = new Date();
    }

    @Override
    public String getSessionId() {
        return "0x" + Long.toHexString(this.connection.getSessionId());
    }

    @Override
    public String getSourceIP() {
        InetSocketAddress sockAddr = this.connection.getRemoteAddress();
        return sockAddr.getAddress().getHostAddress() + ":" + sockAddr.getPort();
    }

    @Override
    public String getName() {
        InetAddress addr = this.connection.getRemoteAddress().getAddress();
        String ip = addr.getHostAddress();
        if (addr instanceof Inet6Address) {
            ip = ObjectName.quote(ip);
        }
        return MBeanRegistry.getInstance().makeFullPath("Connections", ip, this.getSessionId());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String[] getEphemeralNodes() {
        if (this.zk.dataTree != null) {
            Object[] res = this.zk.dataTree.getEphemerals(this.connection.getSessionId()).toArray(new String[0]);
            Arrays.sort(res);
            return res;
        }
        return null;
    }

    @Override
    public String getStartedTime() {
        return this.timeCreated.toString();
    }

    @Override
    public void terminateSession() {
        try {
            this.zk.closeSession(this.connection.getSessionId());
        }
        catch (Exception e) {
            LOG.warn("Unable to closeSession() for session: 0x" + this.getSessionId(), e);
        }
    }

    @Override
    public void terminateConnection() {
        this.connection.close();
    }

    public String toString() {
        return "ConnectionBean{ClientIP=" + ObjectName.quote(this.getSourceIP()) + ",SessionId=0x" + this.getSessionId() + "}";
    }

    @Override
    public long getOutstandingRequests() {
        return this.connection.getStats().getOutstandingRequests();
    }

    @Override
    public long getPacketsReceived() {
        return this.connection.getStats().getPacketsReceived();
    }

    @Override
    public long getPacketsSent() {
        return this.connection.getStats().getPacketsSent();
    }

    @Override
    public int getSessionTimeout() {
        return this.connection.getSessionTimeout();
    }
}

