/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.util.Date;
import org.apache.jute.BinaryInputArchive;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.TraceFormatter;
import org.apache.zookeeper.txn.TxnHeader;

public class LogFormatter {
    private static final Logger LOG = Logger.getLogger(LogFormatter.class);

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("USAGE: LogFormatter log_file");
            System.exit(2);
        }
        FileInputStream fis = new FileInputStream(args[0]);
        BinaryInputArchive logStream = BinaryInputArchive.getArchive(fis);
        do {
            byte[] bytes;
            if ((bytes = logStream.readBuffer("txnEntry")).length == 0) {
                throw new EOFException();
            }
            BinaryInputArchive ia = BinaryInputArchive.getArchive(new ByteArrayInputStream(bytes));
            TxnHeader hdr = new TxnHeader();
            hdr.deserialize(ia, "hdr");
            System.out.println(DateFormat.getDateTimeInstance(3, 1).format(new Date(hdr.getTime())) + " session 0x" + Long.toHexString(hdr.getClientId()) + ":" + hdr.getCxid() + " zxid 0x" + Long.toHexString(hdr.getZxid()) + " " + TraceFormatter.op2String(hdr.getType()));
        } while (logStream.readByte("EOR") == 66);
        LOG.error("Last transaction was partial.");
        throw new EOFException("Last transaction was partial.");
    }
}

