/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Arrays;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ServerConfig {
    protected int clientPort;
    protected String dataDir;
    protected String dataLogDir;
    protected int tickTime = 3000;
    protected int maxClientCnxns;

    public void parse(String[] args) {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("Invalid args:" + Arrays.toString(args));
        }
        this.clientPort = Integer.parseInt(args[0]);
        this.dataLogDir = this.dataDir = args[1];
        if (args.length == 3) {
            this.tickTime = Integer.parseInt(args[2]);
        }
        if (args.length == 4) {
            this.maxClientCnxns = Integer.parseInt(args[3]);
        }
    }

    public void parse(String path) throws QuorumPeerConfig.ConfigException {
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parse(path);
        this.readFrom(config);
    }

    public void readFrom(QuorumPeerConfig config) {
        this.clientPort = config.getClientPort();
        this.dataDir = config.getDataDir();
        this.dataLogDir = config.getDataLogDir();
        this.tickTime = config.getTickTime();
        this.maxClientCnxns = config.getMaxClientCnxns();
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }
}

