/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.ZooTrace;

public class WatchManager {
    private static final Logger LOG = Logger.getLogger(WatchManager.class);
    private HashMap<String, HashSet<Watcher>> watchTable = new HashMap();
    private HashMap<Watcher, HashSet<String>> watch2Paths = new HashMap();

    public synchronized int size() {
        return this.watchTable.size();
    }

    public synchronized void addWatch(String path, Watcher watcher) {
        HashSet<Watcher> list = this.watchTable.get(path);
        if (list == null) {
            list = new HashSet();
            this.watchTable.put(path, list);
        }
        list.add(watcher);
        HashSet<String> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashSet();
            this.watch2Paths.put(watcher, paths);
        }
        paths.add(path);
    }

    public synchronized void removeWatcher(Watcher watcher) {
        HashSet<String> paths = this.watch2Paths.remove(watcher);
        if (paths == null) {
            return;
        }
        for (String p : paths) {
            HashSet<Watcher> list = this.watchTable.get(p);
            if (list == null) continue;
            list.remove(watcher);
            if (list.size() != 0) continue;
            this.watchTable.remove(p);
        }
    }

    public Set<Watcher> triggerWatch(String path, Watcher.Event.EventType type) {
        return this.triggerWatch(path, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Watcher> triggerWatch(String path, Watcher.Event.EventType type, Set<Watcher> supress) {
        HashSet<Watcher> watchers;
        WatchedEvent e = new WatchedEvent(type, Watcher.Event.KeeperState.SyncConnected, path);
        WatchManager watchManager = this;
        synchronized (watchManager) {
            watchers = this.watchTable.remove(path);
            if (watchers == null || watchers.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path);
                }
                return null;
            }
            for (Watcher w : watchers) {
                HashSet<String> paths = this.watch2Paths.get(w);
                if (paths == null) continue;
                paths.remove(path);
            }
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            w.process(e);
        }
        return watchers;
    }
}

