/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMXBean;

public class ZooKeeperServerBean
implements ZooKeeperServerMXBean,
ZKMBeanInfo {
    private final Date startTime = new Date();
    private final String name;
    protected final ZooKeeperServer zks;

    public ZooKeeperServerBean(ZooKeeperServer zks) {
        this.zks = zks;
        this.name = "StandaloneServer_port" + zks.getClientPort();
    }

    @Override
    public String getClientPort() {
        try {
            return InetAddress.getLocalHost().getHostAddress() + ":" + this.zks.getClientPort();
        }
        catch (UnknownHostException e) {
            return "localhost:" + this.zks.getClientPort();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getStartTime() {
        return this.startTime.toString();
    }

    @Override
    public String getVersion() {
        return Version.getFullVersion();
    }

    @Override
    public long getAvgRequestLatency() {
        return this.zks.serverStats().getAvgLatency();
    }

    @Override
    public long getMaxRequestLatency() {
        return this.zks.serverStats().getMaxLatency();
    }

    @Override
    public long getMinRequestLatency() {
        return this.zks.serverStats().getMinLatency();
    }

    @Override
    public long getOutstandingRequests() {
        return this.zks.serverStats().getOutstandingRequests();
    }

    @Override
    public int getTickTime() {
        return this.zks.getTickTime();
    }

    @Override
    public void setTickTime(int tickTime) {
        this.zks.setTickTime(tickTime);
    }

    @Override
    public long getPacketsReceived() {
        return this.zks.serverStats().getPacketsReceived();
    }

    @Override
    public long getPacketsSent() {
        return this.zks.serverStats().getPacketsSent();
    }

    @Override
    public void resetLatency() {
        this.zks.serverStats().resetLatency();
    }

    @Override
    public void resetMaxLatency() {
        this.zks.serverStats().resetMaxLatency();
    }

    @Override
    public void resetStatistics() {
        ServerStats serverStats = this.zks.serverStats();
        serverStats.resetRequestCounters();
        serverStats.resetLatency();
    }
}

