/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;

public class FollowerRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(FollowerRequestProcessor.class);
    FollowerZooKeeperServer zks;
    RequestProcessor nextProcessor;
    LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    boolean finished = false;

    public FollowerRequestProcessor(FollowerZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("FollowerRequestProcessor:" + zks.getServerId());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void run() {
        try {
            while (!this.finished) {
                Request request = this.queuedRequests.take();
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, 2L, 'F', request, "");
                }
                if (request != Request.requestOfDeath) {
                    this.nextProcessor.processRequest(request);
                    switch (request.type) {
                        case 9: {
                            this.zks.pendingSyncs.add(request);
                            this.zks.getFollower().request(request);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: {
                            this.zks.getFollower().request(request);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected exception causing exit", e);
        }
        LOG.info("FollowerRequestProcessor exited loop!");
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

