/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.DataTreeBean;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerBean;
import org.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import org.apache.zookeeper.server.quorum.FollowerSessionTracker;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import org.apache.zookeeper.txn.TxnHeader;

public class FollowerZooKeeperServer
extends ZooKeeperServer {
    private static final Logger LOG = Logger.getLogger(FollowerZooKeeperServer.class);
    private QuorumPeer self;
    CommitProcessor commitProcessor;
    SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder) throws IOException {
        super(logFactory, self.tickTime, treeBuilder);
        this.self = self;
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    @Override
    protected void createSessionTracker() {
        this.sessionTracker = new FollowerSessionTracker(this, this.sessionsWithTimeouts, this.self.getId());
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true);
        this.commitProcessor.start();
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        ((FollowerRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
        this.syncProcessor.start();
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException, InterruptedException {
        this.getFollower().validateSession(cnxn, sessionId, sessionTimeout);
    }

    public HashMap<Long, Integer> getTouchSnapshot() {
        if (this.sessionTracker != null) {
            return ((FollowerSessionTracker)this.sessionTracker).snapshot();
        }
        return new HashMap<Long, Integer>();
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    public void logRequest(TxnHeader hdr, Record txn) {
        Request request = new Request(null, hdr.getClientId(), hdr.getCxid(), hdr.getType(), null, null);
        request.hdr = hdr;
        request.txn = txn;
        request.zxid = hdr.getZxid();
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        this.syncProcessor.processRequest(request);
    }

    public void commit(long zxid) {
        if (this.pendingTxns.size() == 0) {
            LOG.warn("Committing " + Long.toHexString(zxid) + " without seeing txn");
            return;
        }
        long firstElementZxid = ((Request)this.pendingTxns.element()).zxid;
        if (firstElementZxid != zxid) {
            LOG.fatal("Committing zxid 0x" + Long.toHexString(zxid) + " but next pending txn 0x" + Long.toHexString(firstElementZxid));
            System.exit(12);
        }
        Request request = (Request)this.pendingTxns.remove();
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    @Override
    public void addCommittedProposal(Request r) {
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception during shutdown", e);
        }
        try {
            if (this.syncProcessor != null) {
                this.syncProcessor.shutdown();
            }
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception in syncprocessor shutdown", e);
        }
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.dataTree);
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(FollowerBean followerBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = followerBean;
            MBeanRegistry.getInstance().register(followerBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Follower follower) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "follower";
    }
}

