/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.quorum.AckRequestProcessor;
import org.apache.zookeeper.server.quorum.FollowerSyncRequest;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;

public class ProposalRequestProcessor
implements RequestProcessor {
    LeaderZooKeeperServer zks;
    RequestProcessor nextProcessor;
    SyncRequestProcessor syncProcessor;

    public ProposalRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        AckRequestProcessor ackProcessor = new AckRequestProcessor(zks.getLeader());
        this.syncProcessor = new SyncRequestProcessor(zks, ackProcessor);
    }

    public void initialize() {
        this.syncProcessor.start();
    }

    @Override
    public void processRequest(Request request) {
        if (request instanceof FollowerSyncRequest) {
            this.zks.getLeader().processSync((FollowerSyncRequest)request);
        } else {
            this.nextProcessor.processRequest(request);
            if (request.hdr != null) {
                this.zks.getLeader().propose(request);
                this.syncProcessor.processRequest(request);
            }
        }
    }

    @Override
    public void shutdown() {
        this.nextProcessor.shutdown();
        this.syncProcessor.shutdown();
    }
}

