/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.AuthFastLeaderElection;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerHandler;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.QuorumBean;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.apache.zookeeper.server.quorum.RemotePeerBean;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;

public class QuorumPeer
extends Thread
implements QuorumStats.Provider {
    private static final Logger LOG = Logger.getLogger(QuorumPeer.class);
    QuorumBean jmxQuorumBean;
    LocalPeerBean jmxLocalPeerBean;
    LeaderElectionBean jmxLeaderElectionBean;
    Map<Long, QuorumServer> quorumPeers;
    private QuorumVerifier quorumConfig;
    private long myid;
    private volatile Vote currentVote;
    volatile boolean running = true;
    int tickTime;
    int initLimit;
    int syncLimit;
    int tick;
    private ServerState state = ServerState.LOOKING;
    DatagramSocket udpSocket;
    private InetSocketAddress myQuorumAddr;
    private int electionType;
    Election electionAlg;
    NIOServerCnxn.Factory cnxnFactory;
    private FileTxnSnapLog logFactory = null;
    private final QuorumStats quorumStats = new QuorumStats(this);
    ResponderThread responder;
    public Follower follower;
    public Leader leader;

    public int getQuorumSize() {
        return this.quorumPeers.size();
    }

    @Override
    public long getId() {
        return this.myid;
    }

    public synchronized Vote getCurrentVote() {
        return this.currentVote;
    }

    public synchronized void setCurrentVote(Vote v) {
        this.currentVote = v;
    }

    public synchronized void setPeerState(ServerState newState) {
        this.state = newState;
    }

    public synchronized ServerState getPeerState() {
        return this.state;
    }

    public InetSocketAddress getQuorumAddress() {
        return this.myQuorumAddr;
    }

    public QuorumPeer() {
        super("QuorumPeer");
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, NIOServerCnxn.Factory cnxnFactory) throws IOException {
        this(quorumPeers, dataDir, dataLogDir, electionType, myid, tickTime, initLimit, syncLimit, cnxnFactory, (QuorumVerifier)new QuorumMaj(quorumPeers.size()));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, NIOServerCnxn.Factory cnxnFactory, QuorumVerifier quorumConfig) throws IOException {
        this();
        this.cnxnFactory = cnxnFactory;
        this.quorumPeers = quorumPeers;
        this.electionType = electionType;
        this.myid = myid;
        this.tickTime = tickTime;
        this.initLimit = initLimit;
        this.syncLimit = syncLimit;
        this.logFactory = new FileTxnSnapLog(dataLogDir, dataDir);
        this.quorumConfig = quorumConfig == null ? new QuorumMaj(quorumPeers.size()) : quorumConfig;
    }

    QuorumStats quorumStats() {
        return this.quorumStats;
    }

    @Override
    public synchronized void start() {
        this.cnxnFactory.start();
        this.startLeaderElection();
        super.start();
    }

    public synchronized void stopLeaderElection() {
        this.responder.running = false;
        this.responder.interrupt();
    }

    public synchronized void startLeaderElection() {
        this.currentVote = new Vote(this.myid, this.getLastLoggedZxid());
        for (QuorumServer p : this.quorumPeers.values()) {
            if (p.id != this.myid) continue;
            this.myQuorumAddr = p.addr;
            break;
        }
        if (this.myQuorumAddr == null) {
            throw new RuntimeException("My id " + this.myid + " not in the peer list");
        }
        if (this.electionType == 0) {
            try {
                this.udpSocket = new DatagramSocket(this.myQuorumAddr.getPort());
                this.responder = new ResponderThread();
                this.responder.start();
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        this.electionAlg = this.createElectionAlgorithm(this.electionType);
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, new NIOServerCnxn.Factory(clientPort), (QuorumVerifier)new QuorumMaj(quorumPeers.size()));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit, QuorumVerifier quorumConfig) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, new NIOServerCnxn.Factory(clientPort), quorumConfig);
    }

    public long getLastLoggedZxid() {
        return this.logFactory.getLastLoggedZxid();
    }

    protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
        return new Follower(this, new FollowerZooKeeperServer(logFactory, this, (ZooKeeperServer.DataTreeBuilder)new ZooKeeperServer.BasicDataTreeBuilder()));
    }

    protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException {
        return new Leader(this, new LeaderZooKeeperServer(logFactory, this, (ZooKeeperServer.DataTreeBuilder)new ZooKeeperServer.BasicDataTreeBuilder()));
    }

    private Election createElectionAlgorithm(int electionAlgorithm) {
        Election le = null;
        switch (electionAlgorithm) {
            case 0: {
                break;
            }
            case 1: {
                le = new AuthFastLeaderElection(this);
                break;
            }
            case 2: {
                le = new AuthFastLeaderElection(this, true);
                break;
            }
            case 3: {
                QuorumCnxManager mng = new QuorumCnxManager(this);
                QuorumCnxManager.Listener listener = mng.listener;
                if (listener != null) {
                    listener.start();
                    le = new FastLeaderElection(this, mng);
                    break;
                }
                LOG.error("Null listener when initializing cnx manager");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return le;
    }

    protected Election makeLEStrategy() {
        LOG.debug("Initializing leader election protocol...");
        if (this.electionAlg == null) {
            return new LeaderElection(this);
        }
        return this.electionAlg;
    }

    protected synchronized void setLeader(Leader newLeader) {
        this.leader = newLeader;
    }

    protected synchronized void setFollower(Follower newFollower) {
        this.follower = newFollower;
    }

    public synchronized ZooKeeperServer getActiveServer() {
        if (this.leader != null) {
            return this.leader.zk;
        }
        if (this.follower != null) {
            return this.follower.zk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("QuorumPeer:" + this.cnxnFactory.getLocalAddress());
        LOG.debug("Starting quorum peer");
        try {
            this.jmxQuorumBean = new QuorumBean(this);
            MBeanRegistry.getInstance().register(this.jmxQuorumBean, null);
            for (QuorumServer s : this.quorumPeers.values()) {
                ZKMBeanInfo p;
                if (this.getId() == s.id) {
                    this.jmxLocalPeerBean = new LocalPeerBean(this);
                    p = this.jmxLocalPeerBean;
                    try {
                        MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to register with JMX", e);
                        this.jmxLocalPeerBean = null;
                    }
                    continue;
                }
                p = new RemotePeerBean(s);
                try {
                    MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register with JMX", e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxQuorumBean = null;
        }
        try {
            block31: while (this.running) {
                switch (this.getPeerState()) {
                    case LOOKING: {
                        try {
                            LOG.info("LOOKING");
                            this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            this.setPeerState(ServerState.LOOKING);
                        }
                        break;
                    }
                    case FOLLOWING: {
                        try {
                            LOG.info("FOLLOWING");
                            this.setFollower(this.makeFollower(this.logFactory));
                            this.follower.followLeader();
                            continue block31;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            continue block31;
                        }
                        finally {
                            this.follower.shutdown();
                            this.setFollower(null);
                            this.setPeerState(ServerState.LOOKING);
                            continue block31;
                        }
                    }
                    case LEADING: {
                        LOG.info("LEADING");
                        try {
                            this.setLeader(this.makeLeader(this.logFactory));
                            this.leader.lead();
                            this.setLeader(null);
                            continue block31;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            continue block31;
                        }
                        finally {
                            if (this.leader != null) {
                                this.leader.shutdown("Forcing shutdown");
                                this.setLeader(null);
                            }
                            this.setPeerState(ServerState.LOOKING);
                            continue block31;
                        }
                    }
                }
            }
        }
        finally {
            LOG.warn("QuorumPeer main thread exited");
            try {
                MBeanRegistry.getInstance().unregisterAll();
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", e);
            }
            this.jmxQuorumBean = null;
            this.jmxLocalPeerBean = null;
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.leader != null) {
            this.leader.shutdown("quorum Peer shutdown");
        }
        if (this.follower != null) {
            this.follower.shutdown();
        }
        this.cnxnFactory.shutdown();
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQuorumPeers() {
        ArrayList<String> l = new ArrayList<String>();
        QuorumPeer quorumPeer = this;
        synchronized (quorumPeer) {
            if (this.leader != null) {
                HashSet<FollowerHandler> hashSet = this.leader.followers;
                synchronized (hashSet) {
                    for (FollowerHandler fh : this.leader.followers) {
                        if (fh.sock == null) continue;
                        String s = fh.sock.getRemoteSocketAddress().toString();
                        if (this.leader.isFollowerSynced(fh)) {
                            s = s + "*";
                        }
                        l.add(s);
                    }
                }
            } else if (this.follower != null) {
                l.add(this.follower.sock.getRemoteSocketAddress().toString());
            }
        }
        return l.toArray(new String[0]);
    }

    @Override
    public String getServerState() {
        switch (this.getPeerState()) {
            case LOOKING: {
                return "leaderelection";
            }
            case LEADING: {
                return "leading";
            }
            case FOLLOWING: {
                return "following";
            }
        }
        return "unknown";
    }

    public long getMyid() {
        return this.myid;
    }

    public void setMyid(long myid) {
        this.myid = myid;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public void setInitLimit(int initLimit) {
        this.initLimit = initLimit;
    }

    public int getTick() {
        return this.tick;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumConfig;
    }

    public void setQuorumVerifier(QuorumVerifier quorumConfig) {
        this.quorumConfig = quorumConfig;
    }

    public Election getElectionAlg() {
        return this.electionAlg;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public void setSyncLimit(int syncLimit) {
        this.syncLimit = syncLimit;
    }

    public int getElectionType() {
        return this.electionType;
    }

    public void setElectionType(int electionType) {
        this.electionType = electionType;
    }

    public NIOServerCnxn.Factory getCnxnFactory() {
        return this.cnxnFactory;
    }

    public void setCnxnFactory(NIOServerCnxn.Factory cnxnFactory) {
        this.cnxnFactory = cnxnFactory;
    }

    public void setQuorumPeers(Map<Long, QuorumServer> quorumPeers) {
        this.quorumPeers = quorumPeers;
    }

    public int getClientPort() {
        return this.cnxnFactory.getLocalPort();
    }

    public void setClientPort(int clientPort) {
    }

    public void setTxnFactory(FileTxnSnapLog factory) {
        this.logFactory = factory;
    }

    public FileTxnSnapLog getTxnFactory() {
        return this.logFactory;
    }

    class ResponderThread
    extends Thread {
        volatile boolean running;

        ResponderThread() {
            super("ResponderThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] b = new byte[36];
                ByteBuffer responseBuffer = ByteBuffer.wrap(b);
                DatagramPacket packet = new DatagramPacket(b, b.length);
                while (this.running) {
                    QuorumPeer.this.udpSocket.receive(packet);
                    if (packet.getLength() != 4) {
                        LOG.warn("Got more than just an xid! Len = " + packet.getLength());
                    } else {
                        responseBuffer.clear();
                        responseBuffer.getInt();
                        responseBuffer.putLong(QuorumPeer.this.myid);
                        Vote current = QuorumPeer.this.getCurrentVote();
                        switch (QuorumPeer.this.getPeerState()) {
                            case LOOKING: {
                                responseBuffer.putLong(current.id);
                                responseBuffer.putLong(current.zxid);
                                break;
                            }
                            case LEADING: {
                                responseBuffer.putLong(QuorumPeer.this.myid);
                                try {
                                    long proposed;
                                    Leader leader = QuorumPeer.this.leader;
                                    synchronized (leader) {
                                        proposed = QuorumPeer.this.leader.lastProposed;
                                    }
                                    responseBuffer.putLong(proposed);
                                }
                                catch (NullPointerException npe) {}
                                break;
                            }
                            case FOLLOWING: {
                                responseBuffer.putLong(current.id);
                                try {
                                    responseBuffer.putLong(QuorumPeer.this.follower.getZxid());
                                    break;
                                }
                                catch (NullPointerException npe) {
                                    // empty catch block
                                }
                            }
                        }
                        packet.setData(b);
                        QuorumPeer.this.udpSocket.send(packet);
                    }
                    packet.setLength(b.length);
                }
            }
            catch (Exception e) {
                LOG.warn("Unexpected exception", e);
            }
            finally {
                LOG.warn("QuorumPeer responder thread exited");
            }
        }
    }

    public static enum ServerState {
        LOOKING,
        FOLLOWING,
        LEADING;

    }

    public static class QuorumServer {
        public InetSocketAddress addr;
        public InetSocketAddress electionAddr;
        public long id;

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = electionAddr;
        }

        public QuorumServer(long id, InetSocketAddress addr) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = null;
        }
    }

    public static interface Factory {
        public QuorumPeer create(NIOServerCnxn.Factory var1) throws IOException;

        public NIOServerCnxn.Factory createConnectionFactory() throws IOException;
    }
}

