/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMXMLObject;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMXMLSignature
extends DOMStructure
implements XMLSignature {
    private static Logger log;
    private String id;
    private XMLSignature.SignatureValue sv;
    private KeyInfo ki;
    private List objects;
    private SignedInfo si;
    private Document ownerDoc = null;
    private Element localSigElem = null;
    private Element sigElem = null;
    private boolean validationStatus;
    private boolean validated = false;
    private KeySelectorResult ksr;
    private HashMap signatureIdMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMXMLSignature(SignedInfo signedInfo, KeyInfo keyInfo, List list, String string, String string2) {
        if (signedInfo == null) {
            throw new NullPointerException("signedInfo cannot be null");
        }
        this.si = signedInfo;
        this.id = string;
        this.sv = new DOMSignatureValue(string2);
        if (list == null) {
            this.objects = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList = new ArrayList(list);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) instanceof XMLObject) continue;
                throw new ClassCastException("objs[" + i + "] is not an XMLObject");
            }
            this.objects = Collections.unmodifiableList(arrayList);
        }
        this.ki = keyInfo;
    }

    public DOMXMLSignature(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.localSigElem = element;
        this.ownerDoc = this.localSigElem.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(this.localSigElem, "Id");
        Element element2 = DOMUtils.getFirstChildElement(this.localSigElem);
        this.si = new DOMSignedInfo(element2, xMLCryptoContext, provider);
        Element element3 = DOMUtils.getNextSiblingElement(element2);
        this.sv = new DOMSignatureValue(element3);
        Element element4 = DOMUtils.getNextSiblingElement(element3);
        if (element4 != null && element4.getLocalName().equals("KeyInfo")) {
            this.ki = new DOMKeyInfo(element4, xMLCryptoContext, provider);
            element4 = DOMUtils.getNextSiblingElement(element4);
        }
        if (element4 == null) {
            this.objects = Collections.EMPTY_LIST;
        } else {
            ArrayList<DOMXMLObject> arrayList = new ArrayList<DOMXMLObject>();
            while (element4 != null) {
                arrayList.add(new DOMXMLObject(element4, xMLCryptoContext, provider));
                element4 = DOMUtils.getNextSiblingElement(element4);
            }
            this.objects = Collections.unmodifiableList(arrayList);
        }
    }

    public String getId() {
        return this.id;
    }

    public KeyInfo getKeyInfo() {
        return this.ki;
    }

    public SignedInfo getSignedInfo() {
        return this.si;
    }

    public List getObjects() {
        return this.objects;
    }

    public XMLSignature.SignatureValue getSignatureValue() {
        return this.sv;
    }

    public KeySelectorResult getKeySelectorResult() {
        return this.ksr;
    }

    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.marshal(node, null, string, dOMCryptoContext);
    }

    public void marshal(Node node, Node node2, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(node);
        this.sigElem = DOMUtils.createElement(this.ownerDoc, "Signature", "http://www.w3.org/2000/09/xmldsig#", string);
        if (string == null || string.length() == 0) {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, "http://www.w3.org/2000/09/xmldsig#");
        }
        ((DOMSignedInfo)this.si).marshal(this.sigElem, string, dOMCryptoContext);
        ((DOMSignatureValue)this.sv).marshal(this.sigElem, string, dOMCryptoContext);
        if (this.ki != null) {
            ((DOMKeyInfo)this.ki).marshal(this.sigElem, null, string, dOMCryptoContext);
        }
        int n = this.objects.size();
        for (int i = 0; i < n; ++i) {
            ((DOMXMLObject)this.objects.get(i)).marshal(this.sigElem, string, dOMCryptoContext);
        }
        DOMUtils.setAttributeID(this.sigElem, "Id", this.id);
        node.insertBefore(this.sigElem, node2);
    }

    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        int n;
        boolean bl;
        if (xMLValidateContext == null) {
            throw new NullPointerException("validateContext is null");
        }
        if (!(xMLValidateContext instanceof DOMValidateContext)) {
            throw new ClassCastException("validateContext must be of type DOMValidateContext");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        boolean bl2 = this.sv.validate(xMLValidateContext);
        if (!bl2) {
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        List<Reference> list = this.si.getReferences();
        boolean bl3 = true;
        int n2 = list.size();
        for (n = 0; bl3 && n < n2; bl3 &= bl, ++n) {
            Reference reference = list.get(n);
            bl = reference.validate(xMLValidateContext);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Reference[" + reference.getURI() + "] is valid: " + bl);
        }
        if (!bl3) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Couldn't validate the References");
            }
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        n = 1;
        if (Boolean.TRUE.equals(xMLValidateContext.getProperty("org.jcp.xml.dsig.validateManifests"))) {
            int n3 = this.objects.size();
            for (n2 = 0; n != 0 && n2 < n3; ++n2) {
                XMLObject xMLObject = (XMLObject)this.objects.get(n2);
                List<XMLStructure> list2 = xMLObject.getContent();
                int n4 = list2.size();
                for (int i = 0; n != 0 && i < n4; ++i) {
                    int n5;
                    XMLStructure xMLStructure = list2.get(i);
                    if (!(xMLStructure instanceof Manifest)) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "validating manifest");
                    }
                    Manifest manifest = (Manifest)xMLStructure;
                    List<Reference> list3 = manifest.getReferences();
                    int n6 = list3.size();
                    for (int j = 0; n != 0 && j < n6; n &= n5, ++j) {
                        Reference reference = list3.get(j);
                        n5 = reference.validate(xMLValidateContext);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "Manifest ref[" + reference.getURI() + "] is valid: " + (n5 != 0));
                    }
                }
            }
        }
        this.validationStatus = n;
        this.validated = true;
        return this.validationStatus;
    }

    public void sign(XMLSignContext xMLSignContext) throws MarshalException, XMLSignatureException {
        Object object;
        int n;
        if (xMLSignContext == null) {
            throw new NullPointerException("signContext cannot be null");
        }
        DOMSignContext dOMSignContext = (DOMSignContext)xMLSignContext;
        if (dOMSignContext != null) {
            this.marshal(dOMSignContext.getParent(), dOMSignContext.getNextSibling(), DOMUtils.getSignaturePrefix(dOMSignContext), dOMSignContext);
        }
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        this.signatureIdMap = new HashMap();
        this.signatureIdMap.put(this.id, this);
        this.signatureIdMap.put(this.si.getId(), this.si);
        List<Reference> list = this.si.getReferences();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            object = list.get(n);
            this.signatureIdMap.put(object.getId(), object);
        }
        n2 = this.objects.size();
        for (n = 0; n < n2; ++n) {
            object = (XMLObject)this.objects.get(n);
            this.signatureIdMap.put(object.getId(), object);
            List<XMLStructure> list2 = object.getContent();
            int n3 = list2.size();
            for (int i = 0; i < n3; ++i) {
                XMLStructure xMLStructure = list2.get(i);
                if (!(xMLStructure instanceof Manifest)) continue;
                Manifest manifest = (Manifest)xMLStructure;
                this.signatureIdMap.put(manifest.getId(), manifest);
                List<Reference> list3 = manifest.getReferences();
                int n4 = list3.size();
                for (int j = 0; j < n4; ++j) {
                    Reference reference = list3.get(j);
                    arrayList.add(reference);
                    this.signatureIdMap.put(reference.getId(), reference);
                }
            }
        }
        arrayList.addAll(this.si.getReferences());
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (DOMReference)arrayList.get(n);
            this.digestReference((DOMReference)object, xMLSignContext);
        }
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (DOMReference)arrayList.get(n);
            if (((DOMReference)object).isDigested()) continue;
            ((DOMReference)object).digest(xMLSignContext);
        }
        Key key = null;
        KeySelectorResult keySelectorResult = null;
        try {
            keySelectorResult = xMLSignContext.getKeySelector().select(this.ki, KeySelector.Purpose.SIGN, this.si.getSignatureMethod(), xMLSignContext);
            key = keySelectorResult.getKey();
            if (key == null) {
                throw new XMLSignatureException("the keySelector did not find a signing key");
            }
        }
        catch (KeySelectorException keySelectorException) {
            throw new XMLSignatureException("cannot find signing key", keySelectorException);
        }
        object = null;
        try {
            object = ((DOMSignatureMethod)this.si.getSignatureMethod()).sign(key, (DOMSignedInfo)this.si, xMLSignContext);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        ((DOMSignatureValue)this.sv).setValue((byte[])object);
        this.localSigElem = this.sigElem;
        this.ksr = keySelectorResult;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof XMLSignature)) {
            return false;
        }
        XMLSignature xMLSignature = (XMLSignature)object;
        boolean bl2 = this.id == null ? xMLSignature.getId() == null : (bl = this.id.equals(xMLSignature.getId()));
        boolean bl3 = this.ki == null ? xMLSignature.getKeyInfo() == null : this.ki.equals(xMLSignature.getKeyInfo());
        return bl && bl3 && this.sv.equals(xMLSignature.getSignatureValue()) && this.si.equals(xMLSignature.getSignedInfo()) && ((Object)this.objects).equals(xMLSignature.getObjects());
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 54;
    }

    private void digestReference(DOMReference dOMReference, XMLSignContext xMLSignContext) throws XMLSignatureException {
        if (dOMReference.isDigested()) {
            return;
        }
        String string = dOMReference.getURI();
        if (Utils.sameDocumentURI(string)) {
            List<Object> list;
            String string2 = Utils.parseIdFromSameDocumentURI(string);
            if (string2 != null && this.signatureIdMap.containsKey(string2)) {
                list = this.signatureIdMap.get(string2);
                if (list instanceof DOMReference) {
                    this.digestReference((DOMReference)((Object)list), xMLSignContext);
                } else if (list instanceof Manifest) {
                    Manifest manifest = (Manifest)((Object)list);
                    List<Reference> list2 = manifest.getReferences();
                    int n = list2.size();
                    for (int i = 0; i < n; ++i) {
                        this.digestReference((DOMReference)list2.get(i), xMLSignContext);
                    }
                }
            }
            if (string.length() == 0) {
                list = dOMReference.getTransforms();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Transform transform = (Transform)list.get(i);
                    String string3 = transform.getAlgorithm();
                    if (!string3.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") && !string3.equals("http://www.w3.org/2002/06/xmldsig-filter2")) continue;
                    return;
                }
            }
        }
        dOMReference.digest(xMLSignContext);
    }

    static {
        $assertionsDisabled = !DOMXMLSignature.class.desiredAssertionStatus();
        log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
        Init.init();
    }

    public class DOMSignatureValue
    extends DOMStructure
    implements XMLSignature.SignatureValue {
        private String id;
        private byte[] value;
        private String valueBase64;
        private Element sigValueElem;
        private boolean validated = false;
        private boolean validationStatus;

        DOMSignatureValue(String string) {
            this.id = string;
        }

        DOMSignatureValue(Element element) throws MarshalException {
            try {
                this.value = Base64.decode(element);
            }
            catch (Base64DecodingException base64DecodingException) {
                throw new MarshalException(base64DecodingException);
            }
            this.id = DOMUtils.getAttributeValue(element, "Id");
            this.sigValueElem = element;
        }

        public String getId() {
            return this.id;
        }

        public byte[] getValue() {
            return this.value == null ? null : (byte[])this.value.clone();
        }

        public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
            KeySelectorResult keySelectorResult;
            if (xMLValidateContext == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (this.validated) {
                return this.validationStatus;
            }
            SignatureMethod signatureMethod = DOMXMLSignature.this.si.getSignatureMethod();
            Key key = null;
            try {
                keySelectorResult = xMLValidateContext.getKeySelector().select(DOMXMLSignature.this.ki, KeySelector.Purpose.VERIFY, signatureMethod, xMLValidateContext);
                key = keySelectorResult.getKey();
                if (key == null) {
                    throw new XMLSignatureException("the keyselector did not find a validation key");
                }
            }
            catch (KeySelectorException keySelectorException) {
                throw new XMLSignatureException("cannot find validation key", keySelectorException);
            }
            try {
                this.validationStatus = ((DOMSignatureMethod)signatureMethod).verify(key, (DOMSignedInfo)DOMXMLSignature.this.si, this.value, xMLValidateContext);
            }
            catch (Exception exception) {
                throw new XMLSignatureException(exception);
            }
            this.validated = true;
            DOMXMLSignature.this.ksr = keySelectorResult;
            return this.validationStatus;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof XMLSignature.SignatureValue)) {
                return false;
            }
            XMLSignature.SignatureValue signatureValue = (XMLSignature.SignatureValue)object;
            boolean bl = this.id == null ? signatureValue.getId() == null : this.id.equals(signatureValue.getId());
            return bl;
        }

        public int hashCode() {
            return 55;
        }

        public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            this.sigValueElem = DOMUtils.createElement(DOMXMLSignature.this.ownerDoc, "SignatureValue", "http://www.w3.org/2000/09/xmldsig#", string);
            if (this.valueBase64 != null) {
                this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
            }
            DOMUtils.setAttributeID(this.sigValueElem, "Id", this.id);
            node.appendChild(this.sigValueElem);
        }

        void setValue(byte[] byArray) {
            this.value = byArray;
            this.valueBase64 = Base64.encode(byArray);
            this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
        }
    }
}

