/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.invocation.handler;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.dosgi.invocation.handler.HandlingException;
import org.modelbus.dosgi.repository.descriptor.Property;
import org.modelbus.dosgi.repository.descriptor.Session;

public abstract class AbstractHandler {
    protected static final IRepositoryHelper repositoryHelper;
    protected ResourceSet resourceSet;
    private static Session session;
    private static boolean trackModifications;
    private AbstractHandler nextHandler;

    public AbstractHandler(ResourceSet rs, AbstractHandler nextHandler) {
        this.resourceSet = rs;
        this.nextHandler = nextHandler;
    }

    private void initialize() {
        this.resourceSet = new ResourceSetImpl();
    }

    public final Object handleIn(Object param) throws HandlingException {
        if (this.isObjectHandled(param)) {
            this.initialize();
            return this.checkInObject(param);
        }
        return this.getNextHandler().handleIn(param);
    }

    public final void handleUpdate(Object param) throws HandlingException {
        if (this.isObjectHandled(param)) {
            if (this.isObjectModified(param)) {
                this.initialize();
                this.updateObject(param);
            }
        } else {
            this.getNextHandler().handleUpdate(param);
        }
    }

    public final Class<?> handleClass(Class<?> clazz, Type type) throws HandlingException {
        if (this.isClassHandled(clazz) && this.isTypeHandled(type)) {
            return this.convertClass(clazz, type);
        }
        return this.getNextHandler().handleClass(clazz, type);
    }

    public final Type handleType(Class<?> clazz, Type type) throws HandlingException {
        if (this.isClassHandled(clazz) && this.isTypeHandled(type)) {
            return this.convertType(clazz, type);
        }
        return this.getNextHandler().handleType(clazz, type);
    }

    public final Object handleOut(String[] uris, Class methodType, Type type) throws HandlingException {
        if (this.isClassHandled(methodType) && this.isTypeHandled(type)) {
            this.initialize();
            return this.checkOutObject(uris, methodType);
        }
        return this.getNextHandler().handleOut(uris, methodType, type);
    }

    protected boolean isObjectHandled(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.isClassHandled(obj.getClass());
    }

    protected final boolean isClassHandled(Class clz) {
        Class<?> handledClass = this.getHandledClass();
        return handledClass.isAssignableFrom(clz);
    }

    protected final boolean isTypeHandled(Type type) {
        if (type == null) {
            return true;
        }
        Class<?> handledType = this.getHandledType();
        if (type instanceof ParameterizedType) {
            Type paramType;
            ParameterizedType pType = (ParameterizedType)type;
            Type[] arguments = pType.getActualTypeArguments();
            if (arguments.length == 1 && (paramType = arguments[0]) instanceof Class) {
                return handledType.isAssignableFrom((Class)paramType);
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gType = (GenericArrayType)type;
            Type componentType = gType.getGenericComponentType();
            if (componentType instanceof Class) {
                return handledType.isAssignableFrom((Class)componentType);
            }
        } else if (type instanceof Class) {
            if (((Class)type).isArray()) {
                Class<?> componentType = ((Class)type).getComponentType();
                return handledType.isAssignableFrom(componentType);
            }
            return handledType.isAssignableFrom((Class)type);
        }
        return false;
    }

    private AbstractHandler getNextHandler() throws HandlingException {
        if (this.nextHandler != null) {
            return this.nextHandler;
        }
        throw new HandlingException("No handler in charge.");
    }

    protected final Class<?> convertType(Class<?> clazz, Type type) {
        return String.class;
    }

    protected Session getSession() {
        if (session == null) {
            session = this.createSession();
        }
        return session;
    }

    private Session createSession() {
        Session session = new Session();
        session.setId(EcoreUtil.generateUUID());
        Property propertyUserName = new Property();
        propertyUserName.setKey("username");
        propertyUserName.setValue("Admin");
        Property propertyPassword = new Property();
        propertyPassword.setKey("password");
        propertyPassword.setValue("ModelBus");
        session.getProperties().add(propertyUserName);
        session.getProperties().add(propertyPassword);
        return session;
    }

    protected abstract Object checkInObject(Object var1);

    protected abstract Object checkOutObject(String[] var1, Class var2);

    protected abstract void updateObject(Object var1);

    protected abstract Class<?> convertClass(Class<?> var1, Type var2);

    public abstract Class<?> getHandledClass();

    public abstract Class<?> getHandledType();

    public abstract boolean isObjectModified(Object var1);

    public static boolean isTrackingModifications() {
        return trackModifications;
    }

    public static void setTrackModifications(boolean trackModifications) {
        AbstractHandler.trackModifications = trackModifications;
    }

    static {
        trackModifications = false;
        repositoryHelper = ModelBusCoreLib.getRepositoryHelper();
    }
}

