/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.invocation.handler;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelbus.dosgi.invocation.handler.AbstractHandler;
import org.modelbus.dosgi.invocation.handler.EObjectHandler;

public class EObjectArrayHandler
extends AbstractHandler {
    public EObjectArrayHandler(ResourceSet rs, AbstractHandler nextHandler) {
        super(rs, nextHandler);
    }

    @Override
    protected Object checkInObject(Object param) {
        EObject[] eObjArray = (EObject[])param;
        String[] uris = new String[eObjArray.length];
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < eObjArray.length; ++i) {
            EObject eObj = eObjArray[i];
            Resource res = eObj.eResource();
            if (res == null) {
                throw new RuntimeException("Loose EObject: " + eObj);
            }
            if (!resources.contains(res)) {
                resources.add(res);
            }
            uris[i] = EcoreUtil.getURI((EObject)eObj).toString();
        }
        System.out.println("++Do check in of " + eObjArray.length + " elements (" + this.getClass().getName() + ")");
        try {
            repositoryHelper.checkInModel(this.getSession(), resources, Collections.EMPTY_MAP, "Implicit service model check-in");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("++Done check in of " + eObjArray.length + " elements (" + this.getClass().getName() + ")");
        return uris;
    }

    @Override
    protected Object checkOutObject(String[] uris, Class methodType) {
        EObject[] eObjects;
        if (methodType != null) {
            Class<?> methodClass;
            Class<?> componentType;
            Class<?> arrayType = methodType;
            if (methodType instanceof Class && (componentType = (methodClass = methodType).getComponentType()) != null) {
                arrayType = componentType;
            }
            eObjects = (EObject[])Array.newInstance(arrayType, uris.length);
        } else {
            eObjects = new EObject[uris.length];
        }
        for (int i = 0; i < uris.length; ++i) {
            String uri = uris[i];
            String pathWithoutFragment = ((String[])uri.split("#").clone())[0];
            URI fullUri = URI.createURI((String)uri);
            URI httpUri = URI.createURI((String)pathWithoutFragment);
            Resource resource = this.resourceSet.createResource(httpUri);
            System.out.println("++Do check out of eobject: " + httpUri + " (" + this.getClass().getName() + ")");
            try {
                repositoryHelper.checkOutModel(this.getSession(), resource, Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (resource == null) {
                throw new RuntimeException("Resource for URI " + httpUri + " does not exist");
            }
            if (EObjectArrayHandler.isTrackingModifications() && !resource.isTrackingModification()) {
                resource.setTrackingModification(true);
            }
            EObject eObj = resource.getEObject(fullUri.fragment());
            System.out.println("++Done check out of eobject: " + uri + " -> " + eObj + " (" + this.getClass().getName() + ")");
            eObjects[i] = eObj;
        }
        return eObjects;
    }

    @Override
    protected void updateObject(Object param) {
        EObject[] eObjects = (EObject[])param;
        ArrayList<EObject> modifiedEObjects = new ArrayList<EObject>();
        EObjectHandler eObjHandler = new EObjectHandler(this.resourceSet, null);
        for (EObject eObj : eObjects) {
            if (!eObjHandler.isObjectModified(eObj)) continue;
            modifiedEObjects.add(eObj);
        }
        if (!modifiedEObjects.isEmpty()) {
            this.checkInObject(modifiedEObjects.toArray(new EObject[modifiedEObjects.size()]));
        }
    }

    @Override
    protected Class<?> convertClass(Class<?> clazz, Type type) {
        System.out.println("++Replacing " + clazz.getName() + " with String array (" + this.getClass().getName() + ")");
        return String[].class;
    }

    @Override
    public Class<?> getHandledClass() {
        return EObject[].class;
    }

    @Override
    public Class<?> getHandledType() {
        return EObject.class;
    }

    @Override
    public boolean isObjectModified(Object obj) {
        return true;
    }
}

