/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.invocation.handler;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelbus.core.lib.types.IModelBusDataSource;
import org.modelbus.dosgi.invocation.handler.AbstractHandler;

public class ModelBusDataSourceArrayHandler
extends AbstractHandler {
    public ModelBusDataSourceArrayHandler(ResourceSet rs, AbstractHandler nextHandler) {
        super(rs, nextHandler);
    }

    @Override
    protected Object checkInObject(Object param) {
        IModelBusDataSource[] dsArray = (IModelBusDataSource[])param;
        String[] uris = new String[dsArray.length];
        for (int i = 0; i < dsArray.length; ++i) {
            IModelBusDataSource mbDs = dsArray[i];
            if (mbDs.getUri() == null) {
                throw new RuntimeException("Loose data source:" + mbDs);
            }
            System.out.println("++Do check in data source: " + mbDs + " (" + this.getClass().getName() + ")");
            try {
                repositoryHelper.checkInFile(this.getSession(), mbDs, "Implicit service model check-in");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            System.out.println("++Done check data source: " + mbDs + " (" + this.getClass().getName() + ")");
            uris[i] = mbDs.getUri().toString();
        }
        return uris;
    }

    @Override
    protected Object checkOutObject(String[] uris, Class methodType) {
        IModelBusDataSource[] dataSources;
        if (methodType != null) {
            Class<?> methodClass;
            Class<?> componentType;
            Class<?> arrayType = methodType;
            if (methodType instanceof Class && (componentType = (methodClass = methodType).getComponentType()) != null) {
                arrayType = componentType;
            }
            dataSources = (IModelBusDataSource[])Array.newInstance(arrayType, uris.length);
        } else {
            dataSources = new IModelBusDataSource[uris.length];
        }
        for (int i = 0; i < uris.length; ++i) {
            String uri = uris[i];
            System.out.println("++Do check out of data source: " + uri + " (" + this.getClass().getName() + ")");
            IModelBusDataSource mbDs = null;
            try {
                mbDs = repositoryHelper.checkOutFileAsDataSource(this.getSession(), URI.createURI((String)uri), -1L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            System.out.println("++Done check out of data source: " + uri + " -> " + mbDs.getUri() + " (" + this.getClass().getName() + ")");
            dataSources[i] = mbDs;
        }
        return dataSources;
    }

    @Override
    protected void updateObject(Object param) {
    }

    @Override
    protected Class<?> convertClass(Class<?> clazz, Type type) {
        System.out.println("++Replacing " + clazz.getName() + " with String array (" + this.getClass().getName() + ")");
        return String[].class;
    }

    @Override
    public Class<?> getHandledClass() {
        return IModelBusDataSource[].class;
    }

    @Override
    public Class<?> getHandledType() {
        return IModelBusDataSource.class;
    }

    @Override
    public boolean isObjectModified(Object obj) {
        return false;
    }
}

