/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.invocation.handler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelbus.dosgi.invocation.handler.AbstractHandler;
import org.modelbus.dosgi.invocation.handler.ResourceHandler;

public class ResourceCollectionHandler
extends AbstractHandler {
    public ResourceCollectionHandler(ResourceSet rs, AbstractHandler nextHandler) {
        super(rs, nextHandler);
    }

    @Override
    protected Object checkInObject(Object param) {
        ArrayList resourcesList;
        Collection resources = (Collection)param;
        System.out.println("++Do check in of " + resources.size() + " resources");
        if (!(resources instanceof List)) {
            resourcesList = new ArrayList();
            Iterator resIt = resources.iterator();
            while (resIt.hasNext()) {
                resourcesList.add(resIt.next());
            }
        } else {
            resourcesList = (ArrayList)resources;
        }
        try {
            repositoryHelper.checkInModel(this.getSession(), resourcesList, Collections.EMPTY_MAP, "Implicit service model check-in");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("++Done check in of " + resources.size() + " resources");
        String[] resUris = new String[resourcesList.size()];
        Iterator resIt = resourcesList.iterator();
        int i = 0;
        while (resIt.hasNext()) {
            Resource res = (Resource)resIt.next();
            resUris[i] = res.getURI().toString();
            ++i;
        }
        return resUris;
    }

    @Override
    protected Object checkOutObject(String[] uris, Class methodType) {
        for (String uri : uris) {
            String pathWithoutFragment = ((String[])uri.split("#").clone())[0];
            URI httpUri = URI.createURI((String)pathWithoutFragment);
            Resource resource = this.resourceSet.createResource(httpUri);
            System.out.println("++Do check out of resource: " + httpUri);
            try {
                repositoryHelper.checkOutModel(this.getSession(), resource, Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (ResourceCollectionHandler.isTrackingModifications() && !resource.isTrackingModification()) {
                resource.setTrackingModification(true);
            }
            System.out.println("++Done check out of resource: " + httpUri);
        }
        ArrayList resourcesList = new ArrayList();
        resourcesList.addAll(this.resourceSet.getResources());
        return resourcesList;
    }

    @Override
    protected void updateObject(Object param) {
        Collection resources = (Collection)param;
        ArrayList<Resource> modifiedResources = new ArrayList<Resource>();
        ResourceHandler resourceHandler = new ResourceHandler(this.resourceSet, null);
        for (Resource resource : resources) {
            if (!resourceHandler.isObjectModified(resource)) continue;
            modifiedResources.add(resource);
        }
        if (!modifiedResources.isEmpty()) {
            this.checkInObject(modifiedResources.toArray(new Resource[modifiedResources.size()]));
        }
    }

    @Override
    protected Class<?> convertClass(Class<?> clazz, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!(t2 instanceof Class)) continue;
                Class tClass = (Class)t2;
                if (Resource.class.isAssignableFrom(tClass)) {
                    System.out.println("++Replacing " + clazz.getName() + " with String array (" + this.getClass().getName() + ")");
                }
                return String[].class;
            }
        }
        return clazz;
    }

    @Override
    protected boolean isObjectHandled(Object obj) {
        boolean classHandled = super.isObjectHandled(obj);
        if (!classHandled) {
            return false;
        }
        Collection objColl = (Collection)obj;
        if (objColl.isEmpty()) {
            return false;
        }
        for (Object currentObj : objColl) {
            if (currentObj instanceof Resource) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<?> getHandledClass() {
        return Collection.class;
    }

    @Override
    public Class<?> getHandledType() {
        return Resource.class;
    }

    @Override
    public boolean isObjectModified(Object obj) {
        return true;
    }
}

