/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLBuilder {
    private String scheme;
    private String username;
    private String password;
    private String host;
    private int port;
    private String path;
    private List<Pair<String, String>> queryParams;
    private String fragement;

    public URLBuilder() {
        this.queryParams = new ArrayList<Pair<String, String>>();
    }

    public URLBuilder(String baseURL) {
        try {
            URL url = new URL(baseURL);
            this.setScheme(url.getProtocol());
            String userInfo = url.getUserInfo();
            if (!DatatypeHelper.isEmpty(userInfo)) {
                if (userInfo.contains(":")) {
                    String[] userInfoComps = userInfo.split(":");
                    this.setUsername(HTTPTransportUtils.urlDecode(userInfoComps[0]));
                    this.setPassword(HTTPTransportUtils.urlDecode(userInfoComps[1]));
                } else {
                    this.setUsername(userInfo);
                }
            }
            this.setHost(url.getHost());
            this.setPort(url.getPort());
            this.setPath(url.getPath());
            this.queryParams = new ArrayList<Pair<String, String>>();
            String queryString = url.getQuery();
            if (!DatatypeHelper.isEmpty(queryString)) {
                String[] queryComps = queryString.split("&");
                for (int i = 0; i < queryComps.length; ++i) {
                    String paramName;
                    String queryComp = queryComps[i];
                    if (!queryComp.contains("=")) {
                        paramName = HTTPTransportUtils.urlDecode(queryComp);
                        this.queryParams.add(new Pair<String, Object>(paramName, null));
                        continue;
                    }
                    String[] paramComps = queryComp.split("=");
                    paramName = HTTPTransportUtils.urlDecode(paramComps[0]);
                    String paramValue = HTTPTransportUtils.urlDecode(paramComps[1]);
                    this.queryParams.add(new Pair<String, String>(paramName, paramValue));
                }
            }
            this.setFragment(url.getRef());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Given URL is not well formed", e);
        }
    }

    public String getFragment() {
        return this.fragement;
    }

    public void setFragment(String newFragment) {
        this.fragement = DatatypeHelper.safeTrimOrNullString(newFragment);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        this.host = DatatypeHelper.safeTrimOrNullString(newHost);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = DatatypeHelper.safeTrimOrNullString(newPassword);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newPath) {
        this.path = DatatypeHelper.safeTrimOrNullString(newPath);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    public List<Pair<String, String>> getQueryParams() {
        return this.queryParams;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String newScheme) {
        this.scheme = DatatypeHelper.safeTrimOrNullString(newScheme);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String newUsername) {
        this.username = DatatypeHelper.safeTrimOrNullString(newUsername);
    }

    public String buildURL() {
        String queryString;
        StringBuilder builder = new StringBuilder();
        if (!DatatypeHelper.isEmpty(this.scheme)) {
            builder.append(this.scheme);
            builder.append("://");
        }
        if (!DatatypeHelper.isEmpty(this.username)) {
            builder.append(this.username);
            if (!DatatypeHelper.isEmpty(this.password)) {
                builder.append(":");
                builder.append(this.password);
            }
            builder.append("@");
        }
        if (!DatatypeHelper.isEmpty(this.host)) {
            builder.append(this.host);
            if (this.port > 0) {
                builder.append(":");
                builder.append(Integer.toString(this.port));
            }
        }
        if (!DatatypeHelper.isEmpty(this.path)) {
            if (!this.path.startsWith("/")) {
                builder.append("/");
            }
            builder.append(this.path);
        }
        if (!DatatypeHelper.isEmpty(queryString = this.buildQueryString())) {
            builder.append("?");
            builder.append(queryString);
        }
        if (!DatatypeHelper.isEmpty(this.fragement)) {
            builder.append("#");
            builder.append(this.fragement);
        }
        return builder.toString();
    }

    public String buildQueryString() {
        StringBuilder builder = new StringBuilder();
        if (this.queryParams.size() > 0) {
            for (int i = 0; i < this.queryParams.size(); ++i) {
                Pair<String, String> param = this.queryParams.get(i);
                String name = DatatypeHelper.safeTrimOrNullString(param.getFirst());
                if (name == null) continue;
                builder.append(HTTPTransportUtils.urlEncode(name));
                String value = DatatypeHelper.safeTrimOrNullString(param.getSecond());
                if (value != null) {
                    builder.append("=");
                    builder.append(HTTPTransportUtils.urlEncode(value));
                }
                if (i >= this.queryParams.size() - 1) continue;
                builder.append("&");
            }
            return builder.toString();
        }
        return null;
    }
}

