/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo.provider;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.Collection;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.criteria.KeyAlgorithmCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialContext;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.security.keyinfo.KeyInfoResolutionContext;
import org.opensaml.xml.security.keyinfo.provider.AbstractKeyInfoProvider;
import org.opensaml.xml.signature.DSAKeyValue;
import org.opensaml.xml.signature.KeyValue;
import org.opensaml.xml.util.LazySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAKeyValueProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(DSAKeyValueProvider.class);

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return this.getDSAKeyValue(keyInfoChild) != null;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver2, XMLObject keyInfoChild, CriteriaSet criteriaSet, KeyInfoResolutionContext kiContext) throws SecurityException {
        KeyInfoCredentialContext credContext;
        DSAKeyValue keyValue = this.getDSAKeyValue(keyInfoChild);
        if (keyValue == null) {
            return null;
        }
        KeyAlgorithmCriteria algorithmCriteria = criteriaSet.get(KeyAlgorithmCriteria.class);
        if (algorithmCriteria != null && algorithmCriteria.getKeyAlgorithm() != null && !algorithmCriteria.getKeyAlgorithm().equals("DSA")) {
            this.log.debug("Criteria specified non-DSA key algorithm, skipping");
            return null;
        }
        this.log.debug("Attempting to extract credential from a DSAKeyValue");
        PublicKey pubKey = null;
        try {
            pubKey = KeyInfoHelper.getDSAKey(keyValue);
        }
        catch (KeyException e) {
            this.log.error("Error extracting DSA key value", (Throwable)e);
            throw new SecurityException("Error extracting DSA key value", e);
        }
        BasicCredential cred = new BasicCredential();
        cred.setPublicKey(pubKey);
        if (kiContext != null) {
            cred.getKeyNames().addAll(kiContext.getKeyNames());
        }
        if ((credContext = this.buildCredentialContext(kiContext)) != null) {
            cred.getCredentalContextSet().add(credContext);
        }
        this.log.debug("Credential successfully extracted from DSAKeyValue");
        LazySet<Credential> credentialSet = new LazySet<Credential>();
        credentialSet.add(cred);
        return credentialSet;
    }

    protected DSAKeyValue getDSAKeyValue(XMLObject xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        if (xmlObject instanceof DSAKeyValue) {
            return (DSAKeyValue)xmlObject;
        }
        if (xmlObject instanceof KeyValue) {
            return ((KeyValue)xmlObject).getDSAKeyValue();
        }
        return null;
    }
}

