/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.trust;

import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.trust.ExplicitKeyTrustEvaluator;
import org.opensaml.xml.security.trust.TrustedCredentialTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitKeyTrustEngine
implements TrustedCredentialTrustEngine<Credential> {
    private final Logger log = LoggerFactory.getLogger(ExplicitKeyTrustEngine.class);
    private CredentialResolver credentialResolver;
    private ExplicitKeyTrustEvaluator trustEvaluator;

    public ExplicitKeyTrustEngine(CredentialResolver resolver2) {
        if (resolver2 == null) {
            throw new IllegalArgumentException("Credential resolver may not be null");
        }
        this.credentialResolver = resolver2;
        this.trustEvaluator = new ExplicitKeyTrustEvaluator();
    }

    @Override
    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public boolean validate(Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        this.checkParams(untrustedCredential, trustBasisCriteria);
        this.log.debug("Attempting to validate untrusted credential");
        Iterable<Credential> trustedCredentials = this.getCredentialResolver().resolve(trustBasisCriteria);
        return this.trustEvaluator.validate(untrustedCredential, trustedCredentials);
    }

    protected void checkParams(Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (untrustedCredential == null) {
            throw new SecurityException("Untrusted credential was null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }
}

