/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.util.Set;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXTrustEngine;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509CredentialNameEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXX509CredentialTrustEngine
implements PKIXTrustEngine<X509Credential> {
    private final Logger log = LoggerFactory.getLogger(PKIXX509CredentialTrustEngine.class);
    private PKIXValidationInformationResolver pkixResolver;
    private PKIXTrustEvaluator pkixTrustEvaluator;
    private X509CredentialNameEvaluator credNameEvaluator;

    public PKIXX509CredentialTrustEngine(PKIXValidationInformationResolver resolver2) {
        if (resolver2 == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver2;
        this.pkixTrustEvaluator = new CertPathPKIXTrustEvaluator();
        this.credNameEvaluator = new BasicX509CredentialNameEvaluator();
    }

    public PKIXX509CredentialTrustEngine(PKIXValidationInformationResolver resolver2, PKIXTrustEvaluator pkixEvaluator, X509CredentialNameEvaluator nameEvaluator) {
        if (resolver2 == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver2;
        if (pkixEvaluator == null) {
            throw new IllegalArgumentException("PKIX trust evaluator may not be null");
        }
        this.pkixTrustEvaluator = pkixEvaluator;
        this.credNameEvaluator = nameEvaluator;
    }

    @Override
    public PKIXValidationInformationResolver getPKIXResolver() {
        return this.pkixResolver;
    }

    public PKIXTrustEvaluator getPKIXTrustEvaluator() {
        return this.pkixTrustEvaluator;
    }

    public X509CredentialNameEvaluator getX509CredentialNameEvaluator() {
        return this.credNameEvaluator;
    }

    @Override
    public boolean validate(X509Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        this.log.debug("Attempting PKIX validation of untrusted credential");
        if (untrustedCredential == null) {
            this.log.error("X.509 credential was null, unable to perform validation");
            return false;
        }
        if (untrustedCredential.getEntityCertificate() == null) {
            this.log.error("Untrusted X.509 credential's entity certificate was null, unable to perform validation");
            return false;
        }
        Set<String> trustedNames = null;
        if (this.pkixResolver.supportsTrustedNameResolution()) {
            trustedNames = this.pkixResolver.resolveTrustedNames(trustBasisCriteria);
        } else {
            this.log.debug("PKIX resolver does not support resolution of trusted names, skipping name checking");
        }
        return this.validate(untrustedCredential, trustedNames, this.pkixResolver.resolve(trustBasisCriteria));
    }

    protected boolean validate(X509Credential untrustedX509Credential, Set<String> trustedNames, Iterable<PKIXValidationInformation> validationInfoSet) throws SecurityException {
        this.log.debug("Beginning PKIX validation using trusted validation information");
        if (!this.checkNames(trustedNames, untrustedX509Credential)) {
            this.log.debug("Evaluation of credential against trusted names failed. Aborting PKIX validation");
            return false;
        }
        for (PKIXValidationInformation validationInfo : validationInfoSet) {
            try {
                if (!this.pkixTrustEvaluator.validate(validationInfo, untrustedX509Credential)) continue;
                this.log.debug("Credential trust established via PKIX validation");
                return true;
            }
            catch (SecurityException e) {
                this.log.debug("Error performing PKIX validation on untrusted credential", (Throwable)e);
            }
        }
        this.log.debug("Trust of untrusted credential could not be established via PKIX validation");
        return false;
    }

    protected boolean checkNames(Set<String> trustedNames, X509Credential untrustedCredential) throws SecurityException {
        if (this.credNameEvaluator == null) {
            this.log.debug("No credential name evaluator was available, skipping trusted name evaluation");
            return true;
        }
        return this.credNameEvaluator.evaluate(untrustedCredential, trustedNames);
    }
}

