/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.resource.Resource;
import org.osgi.service.http.HttpContext;

class ResourceServlet
extends HttpServlet {
    private final HttpContext m_httpContext;
    private final String m_contextName;
    private final String m_alias;
    private final String m_name;

    ResourceServlet(HttpContext httpContext, String contextName, String alias, String name) {
        this.m_httpContext = httpContext;
        this.m_contextName = "/" + contextName;
        this.m_alias = alias;
        this.m_name = "/".equals(name) ? "" : name;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mapping;
        if (this.m_contextName.equals(this.m_alias)) {
            mapping = this.m_name + request.getRequestURI();
        } else {
            mapping = request.getRequestURI().replaceFirst(this.m_contextName, "/");
            mapping = mapping.replaceFirst(this.m_alias, this.m_name);
        }
        URL url = this.m_httpContext.getResource(mapping);
        if (url != null) {
            String mimeType = this.m_httpContext.getMimeType(mapping);
            if (mimeType == null) {
                URLConnection connection = url.openConnection();
                mimeType = connection.getContentType();
                response.setContentType(mimeType);
            }
            Resource resource = Resource.newResource((URL)url, (boolean)false);
            ServletOutputStream out = response.getOutputStream();
            if (out != null) {
                if (out instanceof HttpConnection.Output) {
                    ((HttpConnection.Output)out).sendContent((Object)resource.getInputStream());
                } else {
                    resource.writeTo((OutputStream)out, 0L, resource.length());
                }
            }
            response.setStatus(200);
        } else {
            response.sendError(404);
        }
    }
}

