/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.service.internal.Configuration;
import org.ops4j.pax.web.service.internal.JettyFactory;
import org.ops4j.pax.web.service.internal.JettyServer;
import org.ops4j.pax.web.service.internal.ServerController;
import org.ops4j.pax.web.service.internal.ServerEvent;
import org.ops4j.pax.web.service.internal.ServerListener;
import org.ops4j.pax.web.service.internal.model.ErrorPageModel;
import org.ops4j.pax.web.service.internal.model.EventListenerModel;
import org.ops4j.pax.web.service.internal.model.FilterModel;
import org.ops4j.pax.web.service.internal.model.ServletModel;
import org.osgi.service.http.HttpContext;

class ServerControllerImpl
implements ServerController {
    private static final Log LOG = LogFactory.getLog(ServerControllerImpl.class);
    private Configuration m_configuration;
    private State m_state;
    private final JettyFactory m_jettyFactory;
    private JettyServer m_jettyServer;
    private final Set<ServerListener> m_listeners;

    ServerControllerImpl(JettyFactory jettyFactory) {
        this.m_jettyFactory = jettyFactory;
        this.m_configuration = null;
        this.m_state = new Unconfigured();
        this.m_listeners = new CopyOnWriteArraySet<ServerListener>();
    }

    public synchronized void start() {
        LOG.info("starting server: " + this);
        this.m_state.start();
    }

    public synchronized void stop() {
        LOG.info("stopping server: " + this);
        this.m_state.stop();
    }

    public synchronized void configure(Configuration configuration) {
        LOG.info("configuring server: " + this + " -> " + configuration);
        if (configuration == null) {
            throw new IllegalArgumentException("configuration == null");
        }
        this.m_configuration = configuration;
        this.m_state.configure();
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        this.m_listeners.add(listener);
    }

    public void addServlet(ServletModel model) {
        this.m_state.addServlet(model);
    }

    public void removeServlet(ServletModel model) {
        this.m_state.removeServlet(model);
    }

    public boolean isStarted() {
        return this.m_state instanceof Started;
    }

    public boolean isConfigured() {
        return !(this.m_state instanceof Unconfigured);
    }

    public void addEventListener(EventListenerModel eventListenerModel) {
        this.m_state.addEventListener(eventListenerModel);
    }

    public void removeEventListener(EventListenerModel eventListenerModel) {
        this.m_state.removeEventListener(eventListenerModel);
    }

    public void removeContext(HttpContext httpContext) {
        this.m_state.removeContext(httpContext);
    }

    public void addFilter(FilterModel filterModel) {
        this.m_state.addFilter(filterModel);
    }

    public void removeFilter(FilterModel filterModel) {
        this.m_state.removeFilter(filterModel);
    }

    public void addErrorPage(ErrorPageModel model) {
        this.m_state.addErrorPage(model);
    }

    public void removeErrorPage(ErrorPageModel model) {
        this.m_state.removeErrorPage(model);
    }

    void notifyListeners(ServerEvent event) {
        for (ServerListener listener : this.m_listeners) {
            listener.stateChanged(event);
        }
    }

    public String toString() {
        return ServerControllerImpl.class.getSimpleName() + "{" + "state=" + this.m_state + "}";
    }

    private class Unconfigured
    extends Stopped {
        private Unconfigured() {
        }

        public void start() {
            throw new IllegalStateException("server is not yet configured.");
        }

        public void configure() {
            ServerControllerImpl.this.m_state = new Stopped();
            ServerControllerImpl.this.notifyListeners(ServerEvent.CONFIGURED);
            ServerControllerImpl.this.start();
        }

        public String toString() {
            return "UNCONFIGURED";
        }
    }

    private class Stopped
    implements State {
        private Stopped() {
        }

        public void start() {
            ServerControllerImpl.this.m_jettyServer = ServerControllerImpl.this.m_jettyFactory.createServer();
            for (String address : ServerControllerImpl.this.m_configuration.getListeningAddresses()) {
                if (ServerControllerImpl.this.m_configuration.isHttpEnabled().booleanValue()) {
                    ServerControllerImpl.this.m_jettyServer.addConnector(ServerControllerImpl.this.m_jettyFactory.createConnector(ServerControllerImpl.this.m_configuration.getHttpPort(), address, ServerControllerImpl.this.m_configuration.useNIO()));
                }
                if (!ServerControllerImpl.this.m_configuration.isHttpSecureEnabled().booleanValue()) continue;
                String sslPassword = ServerControllerImpl.this.m_configuration.getSslPassword();
                String sslKeyPassword = ServerControllerImpl.this.m_configuration.getSslKeyPassword();
                if (sslPassword != null && sslKeyPassword != null) {
                    ServerControllerImpl.this.m_jettyServer.addConnector(ServerControllerImpl.this.m_jettyFactory.createSecureConnector(ServerControllerImpl.this.m_configuration.getHttpSecurePort(), ServerControllerImpl.this.m_configuration.getSslKeystore(), sslPassword, sslKeyPassword, address, ServerControllerImpl.this.m_configuration.getSslKeystoreType(), ServerControllerImpl.this.m_configuration.isClientAuthNeeded(), ServerControllerImpl.this.m_configuration.isClientAuthWanted()));
                    continue;
                }
                LOG.warn("SSL pasword and SSL keystore pasword must be set in order to enable SSL.");
                LOG.warn("SSL connector will not be started");
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("javax.servlet.context.tempdir", ServerControllerImpl.this.m_configuration.getTemporaryDirectory());
            ServerControllerImpl.this.m_jettyServer.configureContext(attributes, ServerControllerImpl.this.m_configuration.getSessionTimeout());
            ServerControllerImpl.this.m_jettyServer.start();
            ServerControllerImpl.this.m_state = new Started();
            ServerControllerImpl.this.notifyListeners(ServerEvent.STARTED);
        }

        public void stop() {
        }

        public void configure() {
            ServerControllerImpl.this.notifyListeners(ServerEvent.CONFIGURED);
        }

        public void addServlet(ServletModel model) {
        }

        public void removeServlet(ServletModel model) {
        }

        public void addEventListener(EventListenerModel eventListenerModel) {
        }

        public void removeEventListener(EventListenerModel eventListenerModel) {
        }

        public void removeContext(HttpContext httpContext) {
        }

        public void addFilter(FilterModel filterModel) {
        }

        public void removeFilter(FilterModel filterModel) {
        }

        public void addErrorPage(ErrorPageModel model) {
        }

        public void removeErrorPage(ErrorPageModel model) {
        }

        public String toString() {
            return "STOPPED";
        }
    }

    private class Started
    implements State {
        private Started() {
        }

        public void start() {
            throw new IllegalStateException("server is already started. must be stopped first.");
        }

        public void stop() {
            ServerControllerImpl.this.m_jettyServer.stop();
            ServerControllerImpl.this.m_state = new Stopped();
            ServerControllerImpl.this.notifyListeners(ServerEvent.STOPPED);
        }

        public void configure() {
            ServerControllerImpl.this.stop();
            ServerControllerImpl.this.start();
        }

        public void addServlet(ServletModel model) {
            ServerControllerImpl.this.m_jettyServer.addServlet(model);
        }

        public void removeServlet(ServletModel model) {
            ServerControllerImpl.this.m_jettyServer.removeServlet(model);
        }

        public void addEventListener(EventListenerModel eventListenerModel) {
            ServerControllerImpl.this.m_jettyServer.addEventListener(eventListenerModel);
        }

        public void removeEventListener(EventListenerModel eventListenerModel) {
            ServerControllerImpl.this.m_jettyServer.removeEventListener(eventListenerModel);
        }

        public void removeContext(HttpContext httpContext) {
            ServerControllerImpl.this.m_jettyServer.removeContext(httpContext);
        }

        public void addFilter(FilterModel filterModel) {
            ServerControllerImpl.this.m_jettyServer.addFilter(filterModel);
        }

        public void removeFilter(FilterModel filterModel) {
            ServerControllerImpl.this.m_jettyServer.removeFilter(filterModel);
        }

        public void addErrorPage(ErrorPageModel model) {
            ServerControllerImpl.this.m_jettyServer.addErrorPage(model);
        }

        public void removeErrorPage(ErrorPageModel model) {
            ServerControllerImpl.this.m_jettyServer.removeErrorPage(model);
        }

        public String toString() {
            return "STARTED";
        }
    }

    private static interface State {
        public void start();

        public void stop();

        public void configure();

        public void addServlet(ServletModel var1);

        public void removeServlet(ServletModel var1);

        public void addEventListener(EventListenerModel var1);

        public void removeEventListener(EventListenerModel var1);

        public void removeContext(HttpContext var1);

        public void addFilter(FilterModel var1);

        public void removeFilter(FilterModel var1);

        public void addErrorPage(ErrorPageModel var1);

        public void removeErrorPage(ErrorPageModel var1);
    }
}

