/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.remoteserviceadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescription {
    private final Map<String, Object> properties;
    private final List<String> interfaces;
    private final long serviceId;
    private final String frameworkUUID;
    private final String id;
    private static final String SERVICE_EXPORTED_ = "service.exported.";
    private static final int SERVICE_EXPORTED_length = "service.exported.".length();

    public EndpointDescription(Map<String, Object> properties) {
        TreeMap<String, Object> props = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        try {
            props.putAll(properties);
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("non-String key in properties");
            iae.initCause(e);
            throw iae;
        }
        if (props.size() < properties.size()) {
            throw new IllegalArgumentException("duplicate keys with different cases in properties: " + new ArrayList(props.keySet()).removeAll(properties.keySet()));
        }
        this.conditionProperties(props);
        this.properties = Collections.unmodifiableMap(props);
        this.interfaces = this.verifyObjectClassProperty();
        this.serviceId = this.verifyLongProperty("endpoint.service.id");
        this.frameworkUUID = this.verifyStringProperty("endpoint.framework.uuid");
        this.id = this.verifyStringProperty("endpoint.id").trim();
        if (this.id == null) {
            throw new IllegalArgumentException("endpoint.id property must be set");
        }
        if (this.getConfigurationTypes().isEmpty()) {
            throw new IllegalArgumentException("service.imported.configs property must be set and non-empty");
        }
    }

    public EndpointDescription(final ServiceReference reference, Map<String, Object> properties) {
        TreeMap<String, Object> props = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (properties != null) {
            try {
                props.putAll(properties);
            }
            catch (ClassCastException e) {
                IllegalArgumentException iae = new IllegalArgumentException("non-String key in properties");
                iae.initCause(e);
                throw iae;
            }
            if (props.size() < properties.size()) {
                throw new IllegalArgumentException("duplicate keys with different cases in properties: " + new ArrayList(props.keySet()).removeAll(properties.keySet()));
            }
        }
        for (String key : reference.getPropertyKeys()) {
            if (props.containsKey(key)) continue;
            props.put(key, reference.getProperty(key));
        }
        if (!props.containsKey("endpoint.service.id")) {
            props.put("endpoint.service.id", reference.getProperty("service.id"));
        }
        if (!props.containsKey("endpoint.framework.uuid")) {
            String uuid = null;
            try {
                uuid = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return reference.getBundle().getBundleContext().getProperty("org.osgi.framework.uuid");
                    }
                });
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (uuid != null) {
                props.put("endpoint.framework.uuid", uuid);
            }
        }
        this.conditionProperties(props);
        this.properties = Collections.unmodifiableMap(props);
        this.interfaces = this.verifyObjectClassProperty();
        this.serviceId = this.verifyLongProperty("endpoint.service.id");
        this.frameworkUUID = this.verifyStringProperty("endpoint.framework.uuid");
        this.id = this.verifyStringProperty("endpoint.id").trim();
        if (this.id == null) {
            throw new IllegalArgumentException("endpoint.id property must be set");
        }
        if (this.getConfigurationTypes().isEmpty()) {
            throw new IllegalArgumentException("service.imported.configs property must be set and non-empty");
        }
    }

    private void conditionProperties(Map<String, Object> props) {
        if (!props.containsKey("service.imported")) {
            props.put("service.imported", Boolean.toString(true));
        }
        Iterator<String> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!SERVICE_EXPORTED_.regionMatches(true, 0, key, 0, SERVICE_EXPORTED_length)) continue;
            iter.remove();
        }
    }

    private List<String> verifyObjectClassProperty() {
        Object o = this.properties.get("objectClass");
        if (!(o instanceof String[])) {
            throw new IllegalArgumentException("objectClass value must be of type String[]");
        }
        String[] objectClass = (String[])o;
        if (objectClass.length < 1) {
            throw new IllegalArgumentException("objectClass is empty");
        }
        for (String interf : objectClass) {
            int index = interf.lastIndexOf(46);
            if (index == -1) continue;
            String packageName = interf.substring(0, index);
            try {
                this.getPackageVersion(packageName);
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Improper version for package " + packageName);
                iae.initCause(e);
                throw iae;
            }
        }
        return Collections.unmodifiableList(Arrays.asList(objectClass));
    }

    private String verifyStringProperty(String propName) {
        Object r = this.properties.get(propName);
        try {
            return (String)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a String: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    private long verifyLongProperty(String propName) {
        Object r = this.properties.get(propName);
        if (r == null) {
            return 0L;
        }
        try {
            return (Long)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a Long: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public Version getPackageVersion(String packageName) {
        String version;
        String key = "endpoint.package.version." + packageName;
        Object value = this.properties.get(key);
        try {
            version = (String)value;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException(key + " property value is not a String");
            iae.initCause(e);
            throw iae;
        }
        return Version.parseVersion((String)version);
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public List<String> getConfigurationTypes() {
        return this.getStringPlusProperty("service.imported.configs");
    }

    public List<String> getIntents() {
        return this.getStringPlusProperty("service.intents");
    }

    private List<String> getStringPlusProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            ArrayList<String> result = new ArrayList<String>(values.length);
            for (String v : values) {
                if (v == null) continue;
                result.add(v);
            }
            return Collections.unmodifiableList(result);
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (Object v : values) {
                if (!(v instanceof String)) continue;
                result.add((String)v);
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.EMPTY_LIST;
    }

    public String getFrameworkUUID() {
        return this.frameworkUUID;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isSameService(EndpointDescription other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.getFrameworkUUID() == null) {
            return false;
        }
        return this.getServiceId() == other.getServiceId() && this.getFrameworkUUID().equals(other.getFrameworkUUID());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EndpointDescription)) {
            return false;
        }
        return this.getId().equals(((EndpointDescription)other).getId());
    }

    public boolean matches(String filter) {
        Filter f;
        try {
            f = FrameworkUtil.createFilter((String)filter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        UnmodifiableDictionary<String, Object> d = new UnmodifiableDictionary<String, Object>(this.properties);
        return f.matchCase(d);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator<Map.Entry<String, Object>> iter = this.properties.entrySet().iterator();
        boolean comma = false;
        while (iter.hasNext()) {
            Class<?> valueType;
            Map.Entry<String, Object> entry = iter.next();
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(entry.getKey());
            sb.append('=');
            Object value = entry.getValue();
            if (value != null && Object[].class.isAssignableFrom(valueType = value.getClass())) {
                EndpointDescription.append(sb, (Object[])value);
                continue;
            }
            sb.append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    private static void append(StringBuffer sb, Object[] value) {
        sb.append('[');
        boolean comma = false;
        int length = value.length;
        for (int i = 0; i < length; ++i) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(String.valueOf(value[i]));
        }
        sb.append(']');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableDictionary<K, V>
    extends Dictionary<K, V> {
        private final Map<K, V> wrapped;

        UnmodifiableDictionary(Map<K, V> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Enumeration<V> elements() {
            return Collections.enumeration(this.wrapped.values());
        }

        @Override
        public V get(Object key) {
            return this.wrapped.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public Enumeration<K> keys() {
            return Collections.enumeration(this.wrapped.keySet());
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

