/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private Tracked tracked;
    private volatile int trackingCount = -1;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = reference;
        this.trackClass = null;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = clazz;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(objectClass=" + clazz.toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public ServiceTracker(BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = null;
        this.listenerFilter = null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(boolean trackAllServices) {
        if (this.tracked != null) {
            return;
        }
        this.tracked = trackAllServices ? new AllTracked() : new Tracked();
        this.trackingCount = 0;
        Tracked tracked = this.tracked;
        synchronized (tracked) {
            try {
                this.context.addServiceListener((ServiceListener)this.tracked, this.listenerFilter);
                ServiceReference[] references = this.listenerFilter == null ? this.getInitialReferences(trackAllServices, null, this.filter.toString()) : (this.trackClass == null ? new ServiceReference[]{this.trackReference} : this.getInitialReferences(trackAllServices, this.trackClass, null));
                this.tracked.setInitialServices(references);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
            }
        }
        this.tracked.trackInitialServices();
    }

    private ServiceReference[] getInitialReferences(boolean trackAllServices, String trackClass, String filterString) throws InvalidSyntaxException {
        if (trackAllServices) {
            return this.context.getAllServiceReferences(trackClass, filterString);
        }
        return this.context.getServiceReferences(trackClass, filterString);
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        this.tracked.close();
        ServiceReference[] references = this.getServiceReferences();
        Tracked outgoing = this.tracked;
        this.tracked = null;
        try {
            this.context.removeServiceListener((ServiceListener)outgoing);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                outgoing.untrack(references[i]);
            }
        }
        this.trackingCount = -1;
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length = tracked.size();
            if (length == 0) {
                return null;
            }
            ServiceReference[] references = new ServiceReference[length];
            Enumeration keys = tracked.keys();
            for (int i = 0; i < length; ++i) {
                references[i] = (ServiceReference)keys.nextElement();
            }
            return references;
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference reference = this.cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            for (int i = 0; i < length; ++i) {
                int ranking;
                Object property2 = references[i].getProperty("service.ranking");
                rankings[i] = ranking = property2 instanceof Integer ? (Integer)property2 : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                    continue;
                }
                if (ranking != maxRanking) continue;
                ++count;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                for (int i = 0; i < length; ++i) {
                    long id;
                    if (rankings[i] != maxRanking || (id = ((Long)references[i].getProperty("service.id")).longValue()) >= minId) continue;
                    index = i;
                    minId = id;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.get(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length;
            ServiceReference[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                return null;
            }
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public Object getService() {
        Object service = this.cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.cachedService = this.getService(reference);
        return this.cachedService;
    }

    public void remove(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(reference);
    }

    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        return tracked.size();
    }

    public int getTrackingCount() {
        return this.trackingCount;
    }

    void modified() {
        ++this.trackingCount;
        this.cachedReference = null;
        this.cachedService = null;
    }

    protected void finalize() throws Throwable {
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        static final long serialVersionUID = 4050764875305137716L;

        protected AllTracked() {
        }
    }

    class Tracked
    extends Hashtable
    implements ServiceListener {
        static final long serialVersionUID = -7420065199791006079L;
        private ArrayList adding = new ArrayList(6);
        private volatile boolean closed = false;
        private LinkedList initial = new LinkedList();

        protected Tracked() {
        }

        protected void setInitialServices(ServiceReference[] references) {
            if (references == null) {
                return;
            }
            int size = references.length;
            for (int i = 0; i < size; ++i) {
                this.initial.add(references[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void trackInitialServices() {
            while (true) {
                ServiceReference reference;
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.initial.size() == 0) {
                        return;
                    }
                    reference = (ServiceReference)this.initial.removeFirst();
                    if (this.get(reference) != null) {
                        continue;
                    }
                    if (this.adding.contains(reference)) {
                        continue;
                    }
                    this.adding.add(reference);
                }
                this.trackAdding(reference);
            }
        }

        protected void close() {
            this.closed = true;
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(reference);
                        break;
                    }
                    if (ServiceTracker.this.filter.match(reference)) {
                        this.track(reference);
                        break;
                    }
                    this.untrack(reference);
                    break;
                }
                case 4: {
                    this.untrack(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void track(ServiceReference reference) {
            Object object;
            Tracked tracked = this;
            synchronized (tracked) {
                object = this.get(reference);
            }
            if (object != null) {
                tracked = this;
                synchronized (tracked) {
                    ServiceTracker.this.modified();
                }
                ServiceTracker.this.customizer.modifiedService(reference, object);
                return;
            }
            tracked = this;
            synchronized (tracked) {
                if (this.adding.contains(reference)) {
                    return;
                }
                this.adding.add(reference);
            }
            this.trackAdding(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(ServiceReference reference) {
            Object object = null;
            boolean becameUntracked = false;
            try {
                object = ServiceTracker.this.customizer.addingService(reference);
            }
            finally {
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.adding.remove(reference)) {
                        if (object != null) {
                            this.put(reference, object);
                            ServiceTracker.this.modified();
                            this.notifyAll();
                        }
                    } else {
                        becameUntracked = true;
                    }
                }
            }
            if (becameUntracked) {
                ServiceTracker.this.customizer.removedService(reference, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void untrack(ServiceReference reference) {
            Object object;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.initial.remove(reference)) {
                    return;
                }
                if (this.adding.remove(reference)) {
                    return;
                }
                object = this.remove(reference);
                if (object == null) {
                    return;
                }
                ServiceTracker.this.modified();
            }
            ServiceTracker.this.customizer.removedService(reference, object);
        }
    }
}

