/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.NotAnAtAspectException;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAspectJAdvisorFactory
implements AspectJAdvisorFactory {
    protected static final ParameterNameDiscoverer ASPECTJ_ANNOTATION_PARAMETER_NAME_DISCOVERER = new AspectJAnnotationParameterNameDiscoverer();
    private static final String AJC_MAGIC = "ajc$";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ParameterNameDiscoverer parameterNameDiscoverer;

    protected static AspectJAnnotation findAspectJAnnotationOnMethod(Method method) {
        Class[] classesToLookFor;
        Class[] classArray = classesToLookFor = new Class[]{Before.class, Around.class, After.class, AfterReturning.class, AfterThrowing.class, Pointcut.class};
        int n = classesToLookFor.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            AspectJAnnotation foundAnnotation = AbstractAspectJAdvisorFactory.findAnnotation(method, c);
            if (foundAnnotation != null) {
                return foundAnnotation;
            }
            ++n2;
        }
        return null;
    }

    private static <A extends Annotation> AspectJAnnotation<A> findAnnotation(Method method, Class<A> toLookFor) {
        A result = AnnotationUtils.findAnnotation(method, toLookFor);
        if (result != null) {
            return new AspectJAnnotation<A>(result);
        }
        return null;
    }

    protected AbstractAspectJAdvisorFactory() {
        PrioritizedParameterNameDiscoverer prioritizedParameterNameDiscoverer = new PrioritizedParameterNameDiscoverer();
        prioritizedParameterNameDiscoverer.addDiscoverer(ASPECTJ_ANNOTATION_PARAMETER_NAME_DISCOVERER);
        this.parameterNameDiscoverer = prioritizedParameterNameDiscoverer;
    }

    @Override
    public boolean isAspect(Class<?> clazz) {
        return this.hasAspectAnnotation(clazz) && !this.compiledByAjc(clazz);
    }

    private boolean hasAspectAnnotation(Class<?> clazz) {
        return AnnotationUtils.findAnnotation(clazz, Aspect.class) != null;
    }

    private boolean compiledByAjc(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().startsWith(AJC_MAGIC)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void validate(Class<?> aspectClass) throws AopConfigException {
        if (aspectClass.getSuperclass().getAnnotation(Aspect.class) != null && !Modifier.isAbstract(aspectClass.getSuperclass().getModifiers())) {
            throw new AopConfigException("[" + aspectClass.getName() + "] cannot extend concrete aspect [" + aspectClass.getSuperclass().getName() + "]");
        }
        AjType ajType = AjTypeSystem.getAjType(aspectClass);
        if (!ajType.isAspect()) {
            throw new NotAnAtAspectException(aspectClass);
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOW) {
            throw new AopConfigException(String.valueOf(aspectClass.getName()) + " uses percflow instantiation model: " + "This is not supported in Spring AOP.");
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOWBELOW) {
            throw new AopConfigException(String.valueOf(aspectClass.getName()) + " uses percflowbelow instantiation model: " + "This is not supported in Spring AOP.");
        }
    }

    protected AspectJExpressionPointcut createPointcutExpression(Method annotatedMethod, Class declarationScope, String[] pointcutParameterNames) {
        Class[] pointcutParameterTypes = new Class[]{};
        if (pointcutParameterNames != null) {
            pointcutParameterTypes = this.extractPointcutParameterTypes(pointcutParameterNames, annotatedMethod);
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(declarationScope, pointcutParameterNames, pointcutParameterTypes);
        ajexp.setLocation(annotatedMethod.toString());
        return ajexp;
    }

    private Class<?>[] extractPointcutParameterTypes(String[] argNames, Method adviceMethod) {
        Class[] ret = new Class[argNames.length];
        Class<?>[] paramTypes = adviceMethod.getParameterTypes();
        if (argNames.length > paramTypes.length) {
            throw new IllegalStateException("Expecting at least " + argNames.length + " arguments in the advice declaration, but only found " + paramTypes.length);
        }
        int typeOffset = paramTypes.length - argNames.length;
        int i = 0;
        while (i < ret.length) {
            ret[i] = paramTypes[i + typeOffset];
            ++i;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AspectJAnnotation<A extends Annotation> {
        private static final String[] EXPRESSION_PROPERTIES = new String[]{"value", "pointcut"};
        private static Map<Class, AspectJAnnotationType> annotationTypes = new HashMap<Class, AspectJAnnotationType>();
        private final A annotation;
        private final AspectJAnnotationType annotationType;
        private final String pointcutExpression;
        private final String argumentNames;

        static {
            annotationTypes.put(Pointcut.class, AspectJAnnotationType.AtPointcut);
            annotationTypes.put(After.class, AspectJAnnotationType.AtAfter);
            annotationTypes.put(AfterReturning.class, AspectJAnnotationType.AtAfterReturning);
            annotationTypes.put(AfterThrowing.class, AspectJAnnotationType.AtAfterThrowing);
            annotationTypes.put(Around.class, AspectJAnnotationType.AtAround);
            annotationTypes.put(Before.class, AspectJAnnotationType.AtBefore);
        }

        public AspectJAnnotation(A annotation2) {
            this.annotation = annotation2;
            this.annotationType = this.determineAnnotationType(annotation2);
            try {
                this.pointcutExpression = this.resolveExpression(annotation2);
                this.argumentNames = (String)annotation2.getClass().getMethod("argNames", new Class[0]).invoke(annotation2, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(annotation2 + " cannot be an AspectJ annotation", ex);
            }
        }

        private AspectJAnnotationType determineAnnotationType(A annotation2) {
            for (Class type : annotationTypes.keySet()) {
                if (!type.isInstance(annotation2)) continue;
                return annotationTypes.get(type);
            }
            throw new IllegalStateException("Unknown annotation type: " + annotation2.toString());
        }

        private String resolveExpression(A annotation2) throws Exception {
            String expression = null;
            String[] stringArray = EXPRESSION_PROPERTIES;
            int n = EXPRESSION_PROPERTIES.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate;
                Method method;
                String methodName = stringArray[n2];
                try {
                    method = annotation2.getClass().getDeclaredMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = null;
                }
                if (method != null && StringUtils.hasText(candidate = (String)method.invoke(annotation2, new Object[0]))) {
                    expression = candidate;
                }
                ++n2;
            }
            return expression;
        }

        public AspectJAnnotationType getAnnotationType() {
            return this.annotationType;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public String getPointcutExpression() {
            return this.pointcutExpression;
        }

        public String getArgumentNames() {
            return this.argumentNames;
        }

        public String toString() {
            return this.annotation.toString();
        }
    }

    private static class AspectJAnnotationParameterNameDiscoverer
    implements ParameterNameDiscoverer {
        private AspectJAnnotationParameterNameDiscoverer() {
        }

        public String[] getParameterNames(Method method) {
            if (method.getParameterTypes().length == 0) {
                return new String[0];
            }
            AspectJAnnotation annotation2 = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(method);
            if (annotation2 == null) {
                return null;
            }
            StringTokenizer strTok = new StringTokenizer(annotation2.getArgumentNames(), ",");
            if (strTok.countTokens() > 0) {
                String[] names = new String[strTok.countTokens()];
                int i = 0;
                while (i < names.length) {
                    names[i] = strTok.nextToken();
                    ++i;
                }
                return names;
            }
            return null;
        }

        public String[] getParameterNames(Constructor ctor) {
            throw new UnsupportedOperationException("Spring AOP cannot handle constructor advice");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AspectJAnnotationType {
        AtPointcut,
        AtBefore,
        AtAfter,
        AtAfterReturning,
        AtAfterThrowing,
        AtAround;

    }
}

