/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    static final String VALUE = "value";
    private static final Map<Class, Boolean> annotatedInterfaceCache = new WeakHashMap<Class, Boolean>();

    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        A ann = resolvedMethod.getAnnotation(annotationType);
        if (ann == null) {
            Annotation[] annotationArray = resolvedMethod.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation metaAnn = annotationArray[n2];
                ann = metaAnn.annotationType().getAnnotation(annotationType);
                if (ann != null) break;
                ++n2;
            }
        }
        return ann;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation2 = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        if (annotation2 == null) {
            annotation2 = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
        }
        while (annotation2 == null) {
            if ((cl = cl.getSuperclass()) == null || cl == Object.class) break;
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation2 = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                if (annotation2 != null) continue;
                annotation2 = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotation2;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class[] ifcs) {
        A annotation2 = null;
        Class[] classArray = ifcs;
        int n = ifcs.length;
        int n2 = 0;
        while (n2 < n) {
            Class iface = classArray[n2];
            if (AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) {
                try {
                    Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    annotation2 = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (annotation2 != null) break;
            }
            ++n2;
        }
        return annotation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            Method[] methodArray = iface.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method ifcMethod = methodArray[n2];
                if (ifcMethod.getAnnotations().length > 0) {
                    found = true;
                    break;
                }
                ++n2;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass2;
        Assert.notNull(clazz, "Class must not be null");
        A annotation2 = clazz.getAnnotation(annotationType);
        if (annotation2 != null) {
            return annotation2;
        }
        Object[] objectArray = clazz.getInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = objectArray[n2];
            annotation2 = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation2 != null) {
                return annotation2;
            }
            ++n2;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            objectArray = clazz.getAnnotations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object ann = objectArray[n2];
                annotation2 = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType);
                if (annotation2 != null) {
                    return annotation2;
                }
                ++n2;
            }
        }
        if ((superClass2 = clazz.getSuperclass()) == null || superClass2 == Object.class) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass2, annotationType);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz) ? clazz : AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        boolean declaredLocally = false;
        for (Annotation annotation2 : Arrays.asList(clazz.getDeclaredAnnotations())) {
            if (!annotation2.annotationType().equals(annotationType)) continue;
            declaredLocally = true;
            break;
        }
        return declaredLocally;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation2) {
        return AnnotationUtils.getAnnotationAttributes(annotation2, false);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation2, boolean classValuesAsString) {
        Method[] methods;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Method[] methodArray = methods = annotation2.annotationType().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                try {
                    String[] value = method.invoke((Object)annotation2, new Object[0]);
                    if (classValuesAsString) {
                        if (value instanceof Class) {
                            value = ((Class)value).getName();
                        } else if (value instanceof Class[]) {
                            Class[] clazzArray = (Class[])value;
                            String[] newValue = new String[clazzArray.length];
                            int i = 0;
                            while (i < clazzArray.length) {
                                newValue[i] = clazzArray[i].getName();
                                ++i;
                            }
                            value = newValue;
                        }
                    }
                    attrs.put(method.getName(), value);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not obtain annotation attribute values", ex);
                }
            }
            ++n2;
        }
        return attrs;
    }

    public static Object getValue(Annotation annotation2) {
        return AnnotationUtils.getValue(annotation2, VALUE);
    }

    public static Object getValue(Annotation annotation2, String attributeName) {
        try {
            Method method = annotation2.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation2, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation2) {
        return AnnotationUtils.getDefaultValue(annotation2, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation2, String attributeName) {
        return AnnotationUtils.getDefaultValue(annotation2.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        try {
            Method method = annotationType.getDeclaredMethod(attributeName, new Class[0]);
            return method.getDefaultValue();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

