/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.cm;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ConfigAdminPropertiesFactoryBean
implements BundleContextAware,
InitializingBean,
FactoryBean {
    private String persistentId;
    private Properties props;
    private BundleContext bundleContext;
    private boolean localOverride = false;
    private Properties localProperties;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText(this.persistentId, "persistentId property is required");
        Assert.notNull(this.bundleContext, "bundleContext property is required");
    }

    public Object getObject() throws Exception {
        if (this.props == null) {
            this.props = this.readProperties();
        }
        return this.props;
    }

    private Properties readProperties() {
        ConfigurationAdmin cm;
        ServiceReference ref;
        Properties properties = new Properties();
        if (this.localProperties != null && !this.localOverride) {
            CollectionUtils.mergePropertiesIntoMap(this.localProperties, properties);
        }
        if ((ref = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName())) != null && (cm = (ConfigurationAdmin)this.bundleContext.getService(ref)) != null) {
            try {
                Dictionary dict = cm.getConfiguration(this.persistentId).getProperties();
                if (dict != null) {
                    Enumeration enm = dict.keys();
                    while (enm.hasMoreElements()) {
                        Object key = enm.nextElement();
                        Object value = dict.get(key);
                        properties.put(key, value);
                    }
                }
            }
            catch (IOException ioe) {
                throw new BeanInitializationException("Cannot retrieve configuration for pid=" + this.persistentId, ioe);
            }
        }
        if (this.localProperties != null && this.localOverride) {
            CollectionUtils.mergePropertiesIntoMap(this.localProperties, properties);
        }
        return properties;
    }

    public Class getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public void setProperties(Properties properties) {
        this.localProperties = properties;
    }

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

