/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal.cm;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.osgi.compendium.internal.cm.CMUtils;
import org.springframework.osgi.compendium.internal.cm.ConfigurationAdminManager;
import org.springframework.osgi.compendium.internal.cm.ManagedServiceBeanManager;
import org.springframework.osgi.compendium.internal.cm.UpdateCallback;
import org.springframework.osgi.compendium.internal.cm.UpdateStrategy;

public class DefaultManagedServiceBeanManager
implements DisposableBean,
ManagedServiceBeanManager {
    private static final Log log = LogFactory.getLog(DefaultManagedServiceBeanManager.class);
    private final Map instanceRegistry = CollectionFactory.createConcurrentMap(8);
    private final UpdateCallback updateCallback;
    private final ConfigurationAdminManager cam;
    private final AbstractBeanFactory bf;

    public DefaultManagedServiceBeanManager(UpdateStrategy updateStrategy, String methodName, ConfigurationAdminManager cam, BeanFactory beanFactory) {
        this.updateCallback = CMUtils.createCallback(updateStrategy, methodName, beanFactory);
        this.bf = beanFactory instanceof AbstractBeanFactory ? (AbstractBeanFactory)beanFactory : null;
        this.cam = cam;
        this.cam.setBeanManager(this);
    }

    public Object register(Object bean) {
        int hashCode = System.identityHashCode(bean);
        if (log.isTraceEnabled()) {
            log.trace("Start tracking instance " + bean.getClass().getName() + "@" + hashCode);
        }
        this.instanceRegistry.put(new Integer(hashCode), bean);
        this.applyInitialInjection(bean, this.cam.getConfiguration());
        return bean;
    }

    void applyInitialInjection(Object instance, Map configuration) {
        if (log.isTraceEnabled()) {
            log.trace("Applying injection to instance " + instance.getClass() + "@" + System.identityHashCode(instance) + " using map " + configuration);
        }
        CMUtils.applyMapOntoInstance(instance, configuration, this.bf);
    }

    public void unregister(Object bean) {
        int hashCode = System.identityHashCode(bean);
        if (log.isTraceEnabled()) {
            log.trace("Stopped tracking instance " + bean.getClass().getName() + "@" + hashCode);
        }
        this.instanceRegistry.remove(new Integer(hashCode));
    }

    public void updated(Map properties) {
        if (this.updateCallback != null) {
            CMUtils.bulkUpdate(this.updateCallback, this.instanceRegistry.values(), properties);
        }
    }

    public void destroy() {
        this.cam.destroy();
        this.instanceRegistry.clear();
    }
}

