/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.osgi.config.AbstractReferenceDefinitionParser;
import org.springframework.osgi.config.OsgiDefaultsDefinition;
import org.springframework.osgi.config.internal.util.AttributeCallback;
import org.springframework.osgi.config.internal.util.ParserUtils;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class ReferenceBeanDefinitionParser
extends AbstractReferenceDefinitionParser {
    private static final String TIMEOUT_PROP = "timeout";
    protected static final String TIMEOUT = "timeout";

    ReferenceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return OsgiServiceProxyFactoryBean.class;
    }

    protected void parseAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks) {
        TimeoutAttributeCallback timeoutCallback = new TimeoutAttributeCallback();
        super.parseAttributes(element, builder, ParserUtils.mergeCallbacks(callbacks, new AttributeCallback[]{timeoutCallback}));
        if (!timeoutCallback.isTimeoutSpecified) {
            this.applyDefaultTimeout(builder, this.defaults);
        }
    }

    protected String mandatoryCardinality() {
        return Cardinality.C_1__1.getLabel();
    }

    protected String optionalCardinality() {
        return Cardinality.C_0__1.getLabel();
    }

    protected void applyDefaultTimeout(BeanDefinitionBuilder builder, OsgiDefaultsDefinition defaults) {
        builder.addPropertyValue("timeout", new TypedStringValue(defaults.getTimeout()));
    }

    static class TimeoutAttributeCallback
    implements AttributeCallback {
        boolean isTimeoutSpecified = false;

        TimeoutAttributeCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            if ("timeout".equals(name)) {
                this.isTimeoutSpecified = true;
            }
            return true;
        }
    }
}

