/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config.internal.adapter;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.config.internal.adapter.CustomListenerAdapterUtils;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.ServiceReferenceProxy;
import org.springframework.osgi.util.internal.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OsgiServiceLifecycleListenerAdapter
implements OsgiServiceLifecycleListener,
InitializingBean,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(OsgiServiceLifecycleListenerAdapter.class);
    private Map bindMethods;
    private Map unbindMethods;
    private Method bindReference;
    private Method unbindReference;
    private String bindMethod;
    private String unbindMethod;
    private boolean isLifecycleListener;
    private BeanFactory beanFactory;
    private String targetBeanName;
    private Object target;
    private boolean initialized;

    public void afterPropertiesSet() {
        Assert.notNull(this.beanFactory);
        Assert.isTrue(this.target != null || StringUtils.hasText(this.targetBeanName), "one of 'target' or 'targetBeanName' properties has to be set");
        if (this.target != null) {
            this.initialized = true;
        }
        this.initialize();
    }

    private void retrieveTarget() {
        this.target = this.beanFactory.getBean(this.targetBeanName);
        this.initialized = true;
    }

    private void initialize() {
        Class<?> clazz = this.target == null ? this.beanFactory.getType(this.targetBeanName) : this.target.getClass();
        this.isLifecycleListener = OsgiServiceLifecycleListener.class.isAssignableFrom(clazz);
        if (this.isLifecycleListener && log.isDebugEnabled()) {
            log.debug(clazz.getName() + " is a lifecycle listener");
        }
        this.bindMethods = CustomListenerAdapterUtils.determineCustomMethods(clazz, this.bindMethod);
        if (StringUtils.hasText(this.bindMethod)) {
            this.bindReference = org.springframework.util.ReflectionUtils.findMethod(clazz, this.bindMethod, ServiceReference.class);
            if (this.bindReference != null) {
                org.springframework.util.ReflectionUtils.makeAccessible(this.bindReference);
            } else if (this.bindMethods.isEmpty()) {
                String beanName = this.target == null ? "" : " bean [" + this.targetBeanName + "] ;";
                throw new IllegalArgumentException("Custom bind method [" + this.bindMethod + "] (with proper signature) not found on " + beanName + "class " + clazz);
            }
        }
        this.unbindMethods = CustomListenerAdapterUtils.determineCustomMethods(clazz, this.unbindMethod);
        if (StringUtils.hasText(this.unbindMethod)) {
            this.unbindReference = org.springframework.util.ReflectionUtils.findMethod(clazz, this.unbindMethod, ServiceReference.class);
            if (this.unbindReference != null) {
                org.springframework.util.ReflectionUtils.makeAccessible(this.unbindReference);
            } else if (this.unbindMethods.isEmpty()) {
                String beanName = this.target == null ? "" : " bean [" + this.targetBeanName + "] ;";
                throw new IllegalArgumentException("Custom unbind method [" + this.unbindMethod + "] (with proper signature) not found on " + beanName + "class " + clazz);
            }
        }
        if (!this.isLifecycleListener && this.bindMethods.isEmpty() && this.unbindMethods.isEmpty() && this.bindReference == null && this.unbindReference == null) {
            throw new IllegalArgumentException("target object needs to implement " + OsgiServiceLifecycleListener.class.getName() + " or custom bind/unbind methods have to be specified");
        }
    }

    private void invokeCustomServiceReferenceMethod(Object target, Method method, Object service) {
        if (method != null) {
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace("invoking listener custom method " + method);
            }
            ServiceReferenceProxy ref = service != null ? ((ImportedOsgiServiceProxy)service).getServiceReference() : null;
            try {
                ReflectionUtils.invokeMethod(method, target, new Object[]{ref});
            }
            catch (Exception ex) {
                Exception cause = ReflectionUtils.getInvocationException(ex);
                log.warn("custom method [" + method + "] threw exception when passing service reference [" + (service != null ? service.getClass().getName() : null) + "]", cause);
            }
        }
    }

    public void bind(Object service, Map properties) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("invoking bind method for service " + service + " with props=" + properties);
        }
        if (!this.initialized) {
            this.retrieveTarget();
        }
        if (this.isLifecycleListener) {
            if (trace) {
                log.trace("invoking listener interface methods");
            }
            try {
                ((OsgiServiceLifecycleListener)this.target).bind(service, properties);
            }
            catch (Exception ex) {
                log.warn("standard bind method on [" + this.target.getClass().getName() + "] threw exception", ex);
            }
        }
        CustomListenerAdapterUtils.invokeCustomMethods(this.target, this.bindMethods, service, properties);
        this.invokeCustomServiceReferenceMethod(this.target, this.bindReference, service);
    }

    public void unbind(Object service, Map properties) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (!this.initialized) {
            this.retrieveTarget();
        }
        if (trace) {
            log.trace("invoking unbind method for service " + service + " with props=" + properties);
        }
        if (this.isLifecycleListener) {
            if (trace) {
                log.trace("invoking listener interface methods");
            }
            try {
                ((OsgiServiceLifecycleListener)this.target).unbind(service, properties);
            }
            catch (Exception ex) {
                log.warn("standard unbind method on [" + this.target.getClass().getName() + "] threw exception", ex);
            }
        }
        CustomListenerAdapterUtils.invokeCustomMethods(this.target, this.unbindMethods, service, properties);
        this.invokeCustomServiceReferenceMethod(this.target, this.unbindReference, service);
    }

    public void setBindMethod(String bindMethod) {
        this.bindMethod = bindMethod;
    }

    public void setUnbindMethod(String unbindMethod) {
        this.unbindMethod = unbindMethod;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setTargetBeanName(String targetName) {
        this.targetBeanName = targetName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

