/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config.internal.util;

import java.util.Locale;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.osgi.config.internal.util.AttributeCallback;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ServiceAttributeCallback
implements AttributeCallback {
    private static final String AUTOEXPORT = "auto-export";
    private static final String AUTOEXPORT_PROP = "autoExport";
    private static final String INTERFACE = "interface";
    private static final String INTERFACES_PROP = "interfaces";
    private static final String CCL_PROP = "contextClassLoader";
    private static final String CONTEXT_CLASSLOADER = "context-class-loader";
    private static final String REF = "ref";

    public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder bldr) {
        String name = attribute.getLocalName();
        if (INTERFACE.equals(name)) {
            bldr.addPropertyValue(INTERFACES_PROP, attribute.getValue());
            return false;
        }
        if (REF.equals(name)) {
            return false;
        }
        if (AUTOEXPORT.equals(name)) {
            String label = attribute.getValue().toUpperCase(Locale.ENGLISH).replace('-', '_');
            bldr.addPropertyValue(AUTOEXPORT_PROP, label);
            return false;
        }
        if (CONTEXT_CLASSLOADER.equals(name)) {
            String value = attribute.getValue().toUpperCase(Locale.ENGLISH).replace('-', '_');
            bldr.addPropertyValue(CCL_PROP, value);
            return false;
        }
        return true;
    }
}

