/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.internal.classloader;

import org.osgi.framework.Bundle;
import org.springframework.osgi.context.internal.classloader.BundleClassLoaderFactory;
import org.springframework.osgi.context.internal.classloader.CachingAopClassLoaderFactory;
import org.springframework.osgi.context.internal.classloader.CachingBundleClassLoaderFactory;
import org.springframework.osgi.context.internal.classloader.ChainedClassLoader;
import org.springframework.osgi.context.internal.classloader.InternalAopClassLoaderFactory;
import org.springframework.util.Assert;

public abstract class ClassLoaderFactory {
    private static InternalAopClassLoaderFactory aopClassLoaderFactory = new CachingAopClassLoaderFactory();
    private static BundleClassLoaderFactory bundleClassLoaderFactory = new CachingBundleClassLoaderFactory();

    public static ChainedClassLoader getAopClassLoaderFor(ClassLoader classLoader) {
        Assert.notNull(classLoader);
        return aopClassLoaderFactory.createClassLoader(classLoader);
    }

    public static ClassLoader getBundleClassLoaderFor(Bundle bundle) {
        Assert.notNull(bundle);
        return bundleClassLoaderFactory.createClassLoader(bundle);
    }
}

