/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.core.OrderComparator;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.DependencyAwareBeanFactoryPostProcessor;
import org.springframework.osgi.context.DependencyInitializationAwareBeanPostProcessor;
import org.springframework.osgi.context.OsgiBundleApplicationContextExecutor;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticaster;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticasterAdapter;
import org.springframework.osgi.context.event.OsgiBundleContextClosedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.context.support.AbstractOsgiBundleApplicationContext;
import org.springframework.osgi.context.support.ContextClassLoaderProvider;
import org.springframework.osgi.context.support.DefaultContextClassLoaderProvider;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.osgi.util.internal.PrivilegedUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractDelegatedExecutionApplicationContext
extends AbstractOsgiBundleApplicationContext
implements DelegatedExecutionOsgiBundleApplicationContext {
    private OsgiBundleApplicationContextExecutor executor = new NoDependenciesWaitRefreshExecutor(this);
    private final Object startupShutdownMonitor = new Object();
    private OsgiBundleApplicationContextEventMulticaster delegatedMulticaster;
    private ContextClassLoaderProvider cclProvider;
    static /* synthetic */ Class class$org$springframework$core$PriorityOrdered;
    static /* synthetic */ Class class$org$springframework$core$Ordered;

    public AbstractDelegatedExecutionApplicationContext() {
    }

    public AbstractDelegatedExecutionApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public void refresh() throws BeansException, IllegalStateException {
        this.executor.refresh();
    }

    public void normalRefresh() {
        Assert.notNull(this.getBundleContext(), "bundle context should be set before refreshing the application context");
        try {
            PrivilegedUtils.executeWithCustomTCCL(this.contextClassLoaderProvider().getContextClassLoader(), new PrivilegedUtils.UnprivilegedExecution(){

                public Object run() {
                    AbstractDelegatedExecutionApplicationContext.super.refresh();
                    AbstractDelegatedExecutionApplicationContext.this.sendRefreshedEvent();
                    return null;
                }
            });
        }
        catch (Throwable th) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Refresh error", th);
            }
            this.sendFailedEvent(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw (Error)th;
        }
    }

    public void normalClose() {
        try {
            PrivilegedUtils.executeWithCustomTCCL(this.contextClassLoaderProvider().getContextClassLoader(), new PrivilegedUtils.UnprivilegedExecution(){

                public Object run() {
                    AbstractDelegatedExecutionApplicationContext.super.doClose();
                    AbstractDelegatedExecutionApplicationContext.this.sendClosedEvent();
                    return null;
                }
            });
        }
        catch (Throwable th) {
            this.sendClosedEvent(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw (Error)th;
        }
    }

    protected void doClose() {
        this.executor.close();
    }

    public void startRefresh() {
        if (!ClassUtils.concurrentLibAvailable()) {
            throw new IllegalStateException("JVM 5+ or backport-concurrent library (for JVM 1.4) required; see the FAQ for more details");
        }
        try {
            PrivilegedUtils.executeWithCustomTCCL(this.contextClassLoaderProvider().getContextClassLoader(), new PrivilegedUtils.UnprivilegedExecution(){

                public Object run() {
                    Object object = AbstractDelegatedExecutionApplicationContext.this.startupShutdownMonitor;
                    synchronized (object) {
                        if (ObjectUtils.isEmpty(AbstractDelegatedExecutionApplicationContext.this.getConfigLocations())) {
                            AbstractDelegatedExecutionApplicationContext.this.setConfigLocations(AbstractDelegatedExecutionApplicationContext.this.getDefaultConfigLocations());
                        }
                        if (!OsgiBundleUtils.isBundleActive(AbstractDelegatedExecutionApplicationContext.this.getBundle())) {
                            throw new ApplicationContextException("Unable to refresh application context: bundle is " + OsgiStringUtils.bundleStateAsString(AbstractDelegatedExecutionApplicationContext.this.getBundle()));
                        }
                        ConfigurableListableBeanFactory beanFactory = null;
                        AbstractDelegatedExecutionApplicationContext.this.prepareRefresh();
                        beanFactory = AbstractDelegatedExecutionApplicationContext.this.obtainFreshBeanFactory();
                        AbstractDelegatedExecutionApplicationContext.this.prepareBeanFactory(beanFactory);
                        try {
                            AbstractDelegatedExecutionApplicationContext.this.postProcessBeanFactory(beanFactory);
                            AbstractDelegatedExecutionApplicationContext.this.invokeBeanFactoryPostProcessors(beanFactory);
                            AbstractDelegatedExecutionApplicationContext.this.registerBeanPostProcessors(beanFactory, class$org$springframework$osgi$context$DependencyInitializationAwareBeanPostProcessor == null ? (class$org$springframework$osgi$context$DependencyInitializationAwareBeanPostProcessor = AbstractDelegatedExecutionApplicationContext.class$("org.springframework.osgi.context.DependencyInitializationAwareBeanPostProcessor")) : class$org$springframework$osgi$context$DependencyInitializationAwareBeanPostProcessor, null, false);
                            return null;
                        }
                        catch (BeansException ex) {
                            beanFactory.destroySingletons();
                            AbstractDelegatedExecutionApplicationContext.this.cancelRefresh(ex);
                            throw ex;
                        }
                    }
                }
            });
        }
        catch (Throwable th) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Pre refresh error", th);
            }
            this.sendFailedEvent(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw (Error)th;
        }
    }

    public void completeRefresh() {
        try {
            PrivilegedUtils.executeWithCustomTCCL(this.contextClassLoaderProvider().getContextClassLoader(), new PrivilegedUtils.UnprivilegedExecution(){

                public Object run() {
                    Object object = AbstractDelegatedExecutionApplicationContext.this.startupShutdownMonitor;
                    synchronized (object) {
                        try {
                            ConfigurableListableBeanFactory beanFactory = AbstractDelegatedExecutionApplicationContext.this.getBeanFactory();
                            AbstractDelegatedExecutionApplicationContext.this.invokeBeanFactoryPostProcessors(beanFactory, class$org$springframework$osgi$context$DependencyAwareBeanFactoryPostProcessor == null ? (class$org$springframework$osgi$context$DependencyAwareBeanFactoryPostProcessor = AbstractDelegatedExecutionApplicationContext.class$("org.springframework.osgi.context.DependencyAwareBeanFactoryPostProcessor")) : class$org$springframework$osgi$context$DependencyAwareBeanFactoryPostProcessor, null);
                            AbstractDelegatedExecutionApplicationContext.this.registerBeanPostProcessors(beanFactory);
                            AbstractDelegatedExecutionApplicationContext.this.initMessageSource();
                            AbstractDelegatedExecutionApplicationContext.this.initApplicationEventMulticaster();
                            AbstractDelegatedExecutionApplicationContext.this.onRefresh();
                            AbstractDelegatedExecutionApplicationContext.this.registerListeners();
                            AbstractDelegatedExecutionApplicationContext.this.finishBeanFactoryInitialization(beanFactory);
                            AbstractDelegatedExecutionApplicationContext.this.finishRefresh();
                            AbstractDelegatedExecutionApplicationContext.this.sendRefreshedEvent();
                            return null;
                        }
                        catch (BeansException ex) {
                            AbstractDelegatedExecutionApplicationContext.this.getBeanFactory().destroySingletons();
                            AbstractDelegatedExecutionApplicationContext.this.cancelRefresh(ex);
                            throw ex;
                        }
                    }
                }
            });
        }
        catch (Throwable th) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Post refresh error", th);
            }
            this.sendFailedEvent(th);
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw (Error)th;
        }
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        this.invokeBeanFactoryPostProcessors(beanFactory, BeanFactoryPostProcessor.class, DependencyAwareBeanFactoryPostProcessor.class);
    }

    private void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory, Class type, Class exclude) {
        Iterator<BeanFactoryPostProcessor> it = this.getBeanFactoryPostProcessors().iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = it.next();
            if (!type.isInstance(factoryProcessor) || exclude != null && exclude.isInstance(factoryProcessor)) continue;
            factoryProcessor.postProcessBeanFactory(beanFactory);
        }
        String[] postProcessorNames = beanFactory.getBeanNamesForType(type, true, false);
        ArrayList<Object> priorityOrderedPostProcessors = new ArrayList<Object>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (int i = 0; i < postProcessorNames.length; ++i) {
            if (exclude != null && this.isTypeMatch(postProcessorNames[i], exclude)) continue;
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$PriorityOrdered == null ? AbstractDelegatedExecutionApplicationContext.class$("org.springframework.core.PriorityOrdered") : class$org$springframework$core$PriorityOrdered)) {
                priorityOrderedPostProcessors.add(beanFactory.getBean(postProcessorNames[i]));
                continue;
            }
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$Ordered == null ? AbstractDelegatedExecutionApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered)) {
                orderedPostProcessorNames.add(postProcessorNames[i]);
                continue;
            }
            nonOrderedPostProcessorNames.add(postProcessorNames[i]);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.invokeBeanFactoryPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<Object> orderedPostProcessors = new ArrayList<Object>();
        Iterator it2 = orderedPostProcessorNames.iterator();
        while (it2.hasNext()) {
            String postProcessorName = (String)it2.next();
            orderedPostProcessors.add(this.getBean(postProcessorName));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.invokeBeanFactoryPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<Object> nonOrderedPostProcessors = new ArrayList<Object>();
        Iterator it3 = nonOrderedPostProcessorNames.iterator();
        while (it3.hasNext()) {
            String postProcessorName = (String)it3.next();
            nonOrderedPostProcessors.add(this.getBean(postProcessorName));
        }
        this.invokeBeanFactoryPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory, List postProcessors) {
        Iterator it = postProcessors.iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor postProcessor = (BeanFactoryPostProcessor)it.next();
            postProcessor.postProcessBeanFactory(beanFactory);
        }
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        this.registerBeanPostProcessors(beanFactory, BeanPostProcessor.class, DependencyInitializationAwareBeanPostProcessor.class, true);
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, Class type, Class exclude, boolean check) {
        String[] postProcessorNames = beanFactory.getBeanNamesForType(type, true, false);
        if (check) {
            int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.length;
            beanFactory.addBeanPostProcessor(new BeanPostProcessorChecker(beanFactory, beanProcessorTargetCount));
        }
        ArrayList<Object> priorityOrderedPostProcessors = new ArrayList<Object>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (int i = 0; i < postProcessorNames.length; ++i) {
            if (exclude != null && this.isTypeMatch(postProcessorNames[i], exclude)) continue;
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$PriorityOrdered == null ? AbstractDelegatedExecutionApplicationContext.class$("org.springframework.core.PriorityOrdered") : class$org$springframework$core$PriorityOrdered)) {
                priorityOrderedPostProcessors.add(beanFactory.getBean(postProcessorNames[i]));
                continue;
            }
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$Ordered == null ? AbstractDelegatedExecutionApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered)) {
                orderedPostProcessorNames.add(postProcessorNames[i]);
                continue;
            }
            nonOrderedPostProcessorNames.add(postProcessorNames[i]);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<Object> orderedPostProcessors = new ArrayList<Object>();
        Iterator it = orderedPostProcessorNames.iterator();
        while (it.hasNext()) {
            String postProcessorName = (String)it.next();
            orderedPostProcessors.add(this.getBean(postProcessorName));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<Object> nonOrderedPostProcessors = new ArrayList<Object>();
        Iterator it2 = nonOrderedPostProcessorNames.iterator();
        while (it2.hasNext()) {
            String postProcessorName = (String)it2.next();
            nonOrderedPostProcessors.add(this.getBean(postProcessorName));
        }
        this.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, List postProcessors) {
        Iterator it = postProcessors.iterator();
        while (it.hasNext()) {
            BeanPostProcessor postProcessor = (BeanPostProcessor)it.next();
            beanFactory.addBeanPostProcessor(postProcessor);
        }
    }

    public void setExecutor(OsgiBundleApplicationContextExecutor executor) {
        this.executor = executor;
    }

    public Object getMonitor() {
        return this.startupShutdownMonitor;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException, BeansException {
    }

    public void setDelegatedEventMulticaster(OsgiBundleApplicationContextEventMulticaster multicaster) {
        this.delegatedMulticaster = multicaster;
    }

    public void setDelegatedEventMulticaster(ApplicationEventMulticaster multicaster) {
        this.delegatedMulticaster = new OsgiBundleApplicationContextEventMulticasterAdapter(multicaster);
    }

    public OsgiBundleApplicationContextEventMulticaster getDelegatedEventMulticaster() {
        return this.delegatedMulticaster;
    }

    private void sendFailedEvent(Throwable cause) {
        if (this.delegatedMulticaster != null) {
            this.delegatedMulticaster.multicastEvent(new OsgiBundleContextFailedEvent(this, this.getBundle(), cause));
        }
    }

    private void sendRefreshedEvent() {
        if (this.delegatedMulticaster != null) {
            this.delegatedMulticaster.multicastEvent(new OsgiBundleContextRefreshedEvent(this, this.getBundle()));
        }
    }

    private void sendClosedEvent() {
        if (this.delegatedMulticaster != null) {
            this.delegatedMulticaster.multicastEvent(new OsgiBundleContextClosedEvent(this, this.getBundle()));
        }
    }

    private void sendClosedEvent(Throwable cause) {
        if (this.delegatedMulticaster != null) {
            this.delegatedMulticaster.multicastEvent(new OsgiBundleContextClosedEvent(this, this.getBundle(), cause));
        }
    }

    private ContextClassLoaderProvider contextClassLoaderProvider() {
        if (this.cclProvider == null) {
            DefaultContextClassLoaderProvider defaultProvider = new DefaultContextClassLoaderProvider();
            defaultProvider.setBeanClassLoader(this.getClassLoader());
            this.cclProvider = defaultProvider;
        }
        return this.cclProvider;
    }

    public void setContextClassLoaderProvider(ContextClassLoaderProvider contextClassLoaderProvider) {
        this.cclProvider = contextClassLoaderProvider;
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final ConfigurableListableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory beanFactory, int beanPostProcessorTargetCount) {
            this.beanFactory = beanFactory;
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (!(bean instanceof BeanPostProcessor) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && AbstractDelegatedExecutionApplicationContext.this.logger.isInfoEnabled()) {
                AbstractDelegatedExecutionApplicationContext.this.logger.info("Bean '" + beanName + "' is not eligible for getting processed by all " + "BeanPostProcessors (for example: not eligible for auto-proxying)");
            }
            return bean;
        }
    }

    private static class NoDependenciesWaitRefreshExecutor
    implements OsgiBundleApplicationContextExecutor {
        private final DelegatedExecutionOsgiBundleApplicationContext context;

        private NoDependenciesWaitRefreshExecutor(DelegatedExecutionOsgiBundleApplicationContext ctx) {
            this.context = ctx;
        }

        public void refresh() throws BeansException, IllegalStateException {
            this.context.normalRefresh();
        }

        public void close() {
            this.context.normalClose();
        }
    }
}

