/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.util.Assert;

class DelegatedNamespaceHandlerResolver
implements NamespaceHandlerResolver {
    private static final Log log = LogFactory.getLog(DelegatedNamespaceHandlerResolver.class);
    private final Map resolvers = new LinkedHashMap(2);

    DelegatedNamespaceHandlerResolver() {
    }

    public void addNamespaceHandler(NamespaceHandlerResolver resolver2, String resolverToString) {
        Assert.notNull(resolver2);
        this.resolvers.put(resolver2, resolverToString);
    }

    public NamespaceHandler resolve(String namespaceUri) {
        boolean trace = log.isTraceEnabled();
        Iterator iterator = this.resolvers.entrySet().iterator();
        while (iterator.hasNext()) {
            NamespaceHandler handler;
            String resolvedMsg;
            Map.Entry entry = iterator.next();
            NamespaceHandlerResolver handlerResolver = (NamespaceHandlerResolver)entry.getKey();
            if (trace) {
                log.trace("Trying to resolve namespace [" + namespaceUri + "] through resolver " + entry.getValue());
            }
            String string = resolvedMsg = (handler = handlerResolver.resolve(namespaceUri)) != null ? "" : "not ";
            if (trace) {
                log.trace("Namespace [" + namespaceUri + "] was " + resolvedMsg + "resolved through handler resolver " + entry.getValue());
            }
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

