/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.Assert;

class OsgiPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private static final Log log = LogFactory.getLog(OsgiPropertyEditorRegistrar.class);
    private static final String PROPERTIES_FILE = "/org/springframework/osgi/context/support/internal/default-property-editors.properties";
    private final Map editors;
    static /* synthetic */ Class class$java$beans$PropertyEditor;

    OsgiPropertyEditorRegistrar() {
        this(OsgiPropertyEditorRegistrar.class.getClassLoader());
    }

    OsgiPropertyEditorRegistrar(ClassLoader classLoader) {
        Properties editorsConfig = new Properties();
        try {
            editorsConfig.load(this.getClass().getResourceAsStream(PROPERTIES_FILE));
        }
        catch (IOException ex) {
            throw (RuntimeException)new IllegalStateException("cannot load default propertiy editorsConfig configuration").initCause(ex);
        }
        if (log.isTraceEnabled()) {
            log.trace("Loaded property editors configuration " + editorsConfig);
        }
        this.editors = new LinkedHashMap(editorsConfig.size());
        this.createEditors(classLoader, editorsConfig);
    }

    private void createEditors(ClassLoader classLoader, Properties configuration) {
        boolean trace = log.isTraceEnabled();
        Iterator<Map.Entry<Object, Object>> iterator = configuration.entrySet().iterator();
        while (iterator.hasNext()) {
            Class<?> editorClass;
            Class<?> key;
            Map.Entry<Object, Object> entry = iterator.next();
            try {
                key = classLoader.loadClass((String)entry.getKey());
                editorClass = classLoader.loadClass((String)entry.getValue());
            }
            catch (ClassNotFoundException ex) {
                throw (RuntimeException)new IllegalArgumentException("Cannot load class").initCause(ex);
            }
            Assert.isAssignable(class$java$beans$PropertyEditor == null ? OsgiPropertyEditorRegistrar.class$("java.beans.PropertyEditor") : class$java$beans$PropertyEditor, editorClass);
            if (trace) {
                log.trace("Adding property editor[" + editorClass + "] for type[" + key + "]");
            }
            this.editors.put(key, editorClass);
        }
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        Iterator iterator = this.editors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry editor = iterator.next();
            Class type = (Class)editor.getKey();
            PropertyEditor editorInstance = (PropertyEditor)BeanUtils.instantiateClass((Class)editor.getValue());
            registry.registerCustomEditor(type, editorInstance);
        }
    }
}

