/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.extender.OsgiServiceDependencyFactory;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextExecutorStateAccessor;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextState;
import org.springframework.osgi.extender.internal.dependencies.startup.MandatoryServiceDependency;
import org.springframework.osgi.extender.internal.util.PrivilegedUtils;
import org.springframework.osgi.service.importer.OsgiServiceDependency;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitEndedEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.osgi.util.OsgiStringUtils;

public class DependencyServiceManager {
    private static final Log log = LogFactory.getLog(DependencyServiceManager.class);
    protected final Map dependencies = Collections.synchronizedMap(new LinkedHashMap());
    protected final Map unsatisfiedDependencies = Collections.synchronizedMap(new LinkedHashMap());
    private final ContextExecutorStateAccessor contextStateAccessor;
    private final BundleContext bundleContext;
    private final ServiceListener listener;
    private final DelegatedExecutionOsgiBundleApplicationContext context;
    private final Runnable executeIfDone;
    private final long waitTime;
    private List dependencyFactories;

    public DependencyServiceManager(ContextExecutorStateAccessor executor, DelegatedExecutionOsgiBundleApplicationContext context, List dependencyFactories, Runnable executeIfDone, long maxWaitTime) {
        this.contextStateAccessor = executor;
        this.context = context;
        this.dependencyFactories = new ArrayList(8);
        if (dependencyFactories != null) {
            this.dependencyFactories.addAll(dependencyFactories);
        }
        this.waitTime = maxWaitTime;
        this.bundleContext = context.getBundleContext();
        this.listener = new DependencyServiceListener();
        this.executeIfDone = executeIfDone;
    }

    protected void findServiceDependencies() throws Exception {
        try {
            PrivilegedUtils.executeWithCustomTCCL(this.context.getClassLoader(), new PrivilegedUtils.UnprivilegedThrowableExecution(){

                public Object run() throws Throwable {
                    DependencyServiceManager.this.doFindDependencies();
                    return null;
                }
            });
        }
        catch (Throwable th) {
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw (Error)th;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.dependencies.size() + " OSGi service dependencies, " + this.unsatisfiedDependencies.size() + " unsatisfied (for beans " + this.unsatisfiedDependencies.values() + ") in " + this.context.getDisplayName());
        }
        if (!this.unsatisfiedDependencies.isEmpty()) {
            log.info(this.context.getDisplayName() + " is waiting for unsatisfied dependencies [" + this.unsatisfiedDependencies.values() + "]");
        }
        if (log.isTraceEnabled()) {
            log.trace("Total OSGi service dependencies beans " + this.dependencies.values());
            log.trace("Unsatified OSGi service dependencies beans " + this.unsatisfiedDependencies.values());
        }
    }

    private void doFindDependencies() throws Exception {
        ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
        boolean debug = log.isDebugEnabled();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Looking for dependency factories inside bean factory [" + beanFactory.toString() + "]");
        }
        Map localFactories = BeanFactoryUtils.beansOfTypeIncludingAncestors(beanFactory, OsgiServiceDependencyFactory.class, true, false);
        if (debug) {
            log.debug("Discovered local dependency factories: " + localFactories.keySet());
        }
        this.dependencyFactories.addAll(localFactories.values());
        Iterator iterator = this.dependencyFactories.iterator();
        while (iterator.hasNext()) {
            OsgiServiceDependencyFactory dependencyFactory = (OsgiServiceDependencyFactory)iterator.next();
            Collection discoveredDependencies = null;
            try {
                discoveredDependencies = dependencyFactory.getServiceDependencies(this.bundleContext, beanFactory);
            }
            catch (Exception ex) {
                log.warn("Dependency factory " + dependencyFactory + " threw exception while detecting dependencies for beanFactory " + beanFactory + " in " + this.context.getDisplayName(), ex);
                throw ex;
            }
            if (discoveredDependencies == null) continue;
            Iterator dependencyIterator = discoveredDependencies.iterator();
            while (dependencyIterator.hasNext()) {
                OsgiServiceDependency dependency = (OsgiServiceDependency)dependencyIterator.next();
                MandatoryServiceDependency msd = new MandatoryServiceDependency(this.bundleContext, dependency);
                this.dependencies.put(msd, dependency.getBeanName());
                if (msd.isServicePresent()) continue;
                log.info("Adding OSGi service dependency for importer [" + msd.getBeanName() + "] matching OSGi filter [" + msd.filterAsString + "]");
                this.unsatisfiedDependencies.put(msd, dependency.getBeanName());
            }
        }
    }

    protected boolean isSatisfied() {
        return this.unsatisfiedDependencies.isEmpty();
    }

    public Map getUnsatisfiedDependencies() {
        return this.unsatisfiedDependencies;
    }

    protected void register() {
        String filter = this.createDependencyFilter();
        if (log.isDebugEnabled()) {
            log.debug(this.context.getDisplayName() + " has registered service dependency dependencyDetector with filter: " + filter);
        }
        this.sendInitialDependencyEvents();
        OsgiListenerUtils.addServiceListener(this.bundleContext, this.listener, filter);
    }

    protected String createDependencyFilter() {
        boolean multiple = this.unsatisfiedDependencies.size() > 1;
        StringBuffer sb = new StringBuffer(100 * this.unsatisfiedDependencies.size());
        if (multiple) {
            sb.append("(|");
        }
        Iterator i = this.unsatisfiedDependencies.keySet().iterator();
        while (i.hasNext()) {
            sb.append(((MandatoryServiceDependency)i.next()).filterAsString);
        }
        if (multiple) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected void deregister() {
        if (log.isDebugEnabled()) {
            log.debug("Deregistering service dependency dependencyDetector for " + this.context.getDisplayName());
        }
        OsgiListenerUtils.removeServiceListener(this.bundleContext, this.listener);
    }

    private void sendInitialDependencyEvents() {
        Iterator iterator = this.unsatisfiedDependencies.keySet().iterator();
        while (iterator.hasNext()) {
            MandatoryServiceDependency entry = (MandatoryServiceDependency)iterator.next();
            OsgiServiceDependencyWaitStartingEvent nestedEvent = new OsgiServiceDependencyWaitStartingEvent(this.context, entry.getServiceDependency(), this.waitTime);
            BootstrappingDependencyEvent dependencyEvent = new BootstrappingDependencyEvent(this.context, this.context.getBundle(), nestedEvent);
            this.publishEvent(dependencyEvent);
        }
    }

    private void sendDependencyUnsatisfiedEvent(MandatoryServiceDependency dependency) {
        OsgiServiceDependencyWaitStartingEvent nestedEvent = new OsgiServiceDependencyWaitStartingEvent(this.context, dependency.getServiceDependency(), this.waitTime);
        BootstrappingDependencyEvent dependencyEvent = new BootstrappingDependencyEvent(this.context, this.context.getBundle(), nestedEvent);
        this.publishEvent(dependencyEvent);
    }

    private void sendDependencySatisfiedEvent(MandatoryServiceDependency dependency) {
        OsgiServiceDependencyWaitEndedEvent nestedEvent = new OsgiServiceDependencyWaitEndedEvent(this.context, dependency.getServiceDependency(), this.waitTime);
        BootstrappingDependencyEvent dependencyEvent = new BootstrappingDependencyEvent(this.context, this.context.getBundle(), nestedEvent);
        this.publishEvent(dependencyEvent);
    }

    private void publishEvent(BootstrappingDependencyEvent dependencyEvent) {
        this.contextStateAccessor.getEventMulticaster().multicastEvent(dependencyEvent);
    }

    private class DependencyServiceListener
    implements ServiceListener {
        private DependencyServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            boolean trace = log.isTraceEnabled();
            try {
                if (DependencyServiceManager.this.unsatisfiedDependencies.isEmpty()) {
                    if (trace) {
                        log.trace("Handling service event, but no unsatisfied dependencies exist for " + DependencyServiceManager.this.context.getDisplayName());
                    }
                    return;
                }
                ServiceReference ref = serviceEvent.getServiceReference();
                if (trace) {
                    log.trace("Handling service event [" + OsgiStringUtils.nullSafeToString(serviceEvent) + ":" + OsgiStringUtils.nullSafeToString(ref) + "] for " + DependencyServiceManager.this.context.getDisplayName());
                }
                this.updateDependencies(serviceEvent);
                ContextState state = DependencyServiceManager.this.contextStateAccessor.getContextState();
                if (state.isResolved()) {
                    DependencyServiceManager.this.deregister();
                    return;
                }
                if (DependencyServiceManager.this.unsatisfiedDependencies.isEmpty()) {
                    DependencyServiceManager.this.deregister();
                    log.info("No unsatisfied OSGi service dependencies; completing initialization for " + DependencyServiceManager.this.context.getDisplayName());
                    DependencyServiceManager.this.executeIfDone.run();
                }
            }
            catch (Throwable e) {
                log.error("Exception during dependency processing for " + DependencyServiceManager.this.context.getDisplayName(), e);
            }
        }

        private void updateDependencies(ServiceEvent serviceEvent) {
            boolean trace = log.isTraceEnabled();
            boolean debug = log.isDebugEnabled();
            Iterator i = DependencyServiceManager.this.dependencies.keySet().iterator();
            block4: while (i.hasNext()) {
                MandatoryServiceDependency dependency = (MandatoryServiceDependency)i.next();
                if (dependency.matches(serviceEvent)) {
                    switch (serviceEvent.getType()) {
                        case 1: 
                        case 2: {
                            DependencyServiceManager.this.unsatisfiedDependencies.remove(dependency);
                            if (debug) {
                                log.debug("Found service for " + DependencyServiceManager.this.context.getDisplayName() + "; eliminating " + dependency + ", remaining [" + DependencyServiceManager.this.unsatisfiedDependencies + "]");
                            }
                            DependencyServiceManager.this.sendDependencySatisfiedEvent(dependency);
                            continue block4;
                        }
                        case 4: {
                            DependencyServiceManager.this.unsatisfiedDependencies.put(dependency, dependency.getBeanName());
                            if (debug) {
                                log.debug("Service unregistered; adding " + dependency);
                            }
                            DependencyServiceManager.this.sendDependencyUnsatisfiedEvent(dependency);
                            continue block4;
                        }
                    }
                    if (!debug) continue;
                    log.debug("Unknown service event type for: " + dependency);
                    continue;
                }
                if (!trace) continue;
                log.trace(dependency + " does not match: " + OsgiStringUtils.nullSafeToString(serviceEvent.getServiceReference()));
            }
        }
    }
}

