/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextClosedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.internal.activator.ContextLoaderListener;

public class DefaultOsgiBundleApplicationContextListener
implements OsgiBundleApplicationContextListener {
    private static final Log log = LogFactory.getLog(ContextLoaderListener.class);

    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        String applicationContextString = event.getApplicationContext().getDisplayName();
        if (event instanceof OsgiBundleContextRefreshedEvent) {
            log.info("Application context successfully refreshed (" + applicationContextString + ")");
        }
        if (event instanceof OsgiBundleContextFailedEvent) {
            OsgiBundleContextFailedEvent failureEvent = (OsgiBundleContextFailedEvent)event;
            log.error("Application context refresh failed (" + applicationContextString + ")", failureEvent.getFailureCause());
        }
        if (event instanceof OsgiBundleContextClosedEvent) {
            OsgiBundleContextClosedEvent closedEvent = (OsgiBundleContextClosedEvent)event;
            Throwable error = closedEvent.getFailureCause();
            if (error == null) {
                log.info("Application context succesfully closed (" + applicationContextString + ")");
            } else {
                log.error("Application context close failed (" + applicationContextString + ")", error);
            }
        }
    }
}

